/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SVTOOLS_CONTROLDIMS_HRC
#define INCLUDED_SVTOOLS_CONTROLDIMS_HRC

// From: Dialogue Specification and Guidelines - Visual Design V1.3
// by Christian Jansen

// all values have to be mapped by MAP_APPFONT

// Base
#define RSC_BS_CHARHEIGHT                   8

// control dimensions
#define RSC_CD_PUSHBUTTON_WIDTH             50
#define RSC_CD_PUSHBUTTON_HEIGHT            14

#define RSC_CD_TEXTBOX_HEIGHT               12      // also numeric fields etc.

// spacings
#define RSC_SP_CTRL_X                       6       // controls that are unrelated
#define RSC_SP_CTRL_GROUP_Y                 4
#define RSC_SP_CTRL_DESC_X                  3       // between description text and related control
#define RSC_SP_CTRL_DESC_Y                  3

// dialog inner border
#define RSC_SP_DLG_INNERBORDER_LEFT         6
#define RSC_SP_DLG_INNERBORDER_TOP          6
#define RSC_SP_DLG_INNERBORDER_RIGHT        6

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
