/*
 * copyright (c) 2006 Michael Niedermayer <michaelni@gmx.at>
 *
 * This file is part of Libav.
 *
 * Libav is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Libav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Libav; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVUTIL_MD5_H
#define AVUTIL_MD5_H

#include <stddef.h>
#include <stdint.h>

#include "attributes.h"
#include "version.h"

/**
 * @defgroup lavu_md5 MD5
 * @ingroup lavu_crypto
 * @{
 */

struct AVMD5;

struct AVMD5 *av_md5_alloc(void);
void av_md5_init(struct AVMD5 *ctx);
void av_md5_final(struct AVMD5 *ctx, uint8_t *dst);
#if FF_API_CRYPTO_SIZE_T
void av_md5_update(struct AVMD5 *ctx, const uint8_t *src, const int len);
void av_md5_sum(uint8_t *dst, const uint8_t *src, const int len);
#else
void av_md5_update(struct AVMD5 *ctx, const uint8_t *src, size_t len);
void av_md5_sum(uint8_t *dst, const uint8_t *src, size_t len);
#endif

/**
 * @}
 */

#endif /* AVUTIL_MD5_H */
