/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import javax.media.Control;
import org.bluray.media.StreamNotAvailableException;
import org.davic.media.LanguageNotAvailableException;
import org.davic.media.NotAuthorizedException;
import org.videolan.StreamInfo;
import org.videolan.media.content.playlist.Handler;

public abstract class StreamControl
implements Control {
    protected Handler player;

    protected StreamControl(Handler player) {
        this.player = player;
    }

    protected abstract StreamInfo[] getStreams();

    protected abstract void setStreamNumber(int var1);

    protected String getDefaultLanguage() {
        return "";
    }

    protected StreamInfo getCurrentStream() {
        StreamInfo[] streams = this.getStreams();
        int stream = this.getCurrentStreamNumber();
        if (streams == null || stream <= 0 || stream > streams.length) {
            return null;
        }
        return streams[stream - 1];
    }

    protected String languageFromInteger(int value) {
        char[] language = new char[]{(char)(value >> 16 & 0xFF), (char)(value >> 8 & 0xFF), (char)(value & 0xFF)};
        return String.valueOf(language);
    }

    public Component getControlComponent() {
        return null;
    }

    public abstract int getCurrentStreamNumber();

    public int[] listAvailableStreamNumbers() {
        StreamInfo[] streams = this.getStreams();
        if (streams == null) {
            return new int[0];
        }
        int[] ret = new int[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            ret[i] = i + 1;
        }
        return ret;
    }

    public void selectStreamNumber(int num) throws StreamNotAvailableException {
        if (num < 1) {
            throw new StreamNotAvailableException();
        }
        StreamInfo[] streams = this.getStreams();
        if (streams == null || num > streams.length) {
            throw new StreamNotAvailableException();
        }
        this.setStreamNumber(num);
    }

    public String[] listAvailableLanguages() {
        StreamInfo[] streams = this.getStreams();
        if (streams == null) {
            return new String[0];
        }
        String[] ret = new String[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            ret[i] = streams[i].getLang();
        }
        return ret;
    }

    public String getCurrentLanguage() {
        StreamInfo stream = this.getCurrentStream();
        if (stream == null) {
            return "";
        }
        return stream.getLang();
    }

    public String selectDefaultLanguage() throws NotAuthorizedException {
        String language = this.getDefaultLanguage();
        try {
            this.selectLanguage(language);
        }
        catch (LanguageNotAvailableException e) {
            throw new NotAuthorizedException();
        }
        return language;
    }

    public void selectLanguage(String language) throws LanguageNotAvailableException, NotAuthorizedException {
        StreamInfo[] streams = this.getStreams();
        if (streams == null) {
            throw new NotAuthorizedException();
        }
        for (int i = 0; i < streams.length; ++i) {
            if (!streams[i].getLang().equals(language)) continue;
            try {
                this.selectStreamNumber(i + 1);
                continue;
            }
            catch (StreamNotAvailableException e) {
                throw new NotAuthorizedException();
            }
        }
        throw new LanguageNotAvailableException();
    }
}

