/*
** FAAD - Freeware Advanced Audio Decoder
** Copyright (C) 2002 M. Bakker
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: iq_table.h,v 1.3 2003/05/16 08:31:14 menno Exp $
**/

#ifndef IQ_TABLE_H__
#define IQ_TABLE_H__

#ifdef __cplusplus
extern "C" {
#endif

/* !!!DON'T CHANGE IQ_TABLE_SIZE!!! */
#define IQ_TABLE_SIZE  1026

#ifndef FIXED_POINT

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

static real_t iq_table[] =
{
    0.0000000000,
    1.0000000000,
    2.5198420998,
    4.3267487109,
    6.3496042079,
    8.5498797334,
    10.9027235570,
    13.3905182794,
    16.0000000000,
    18.7207544075,
    21.5443469003,
    24.4637809963,
    27.4731418213,
    30.5673509404,
    33.7419916985,
    36.9931811150,
    40.3174735966,
    43.7117870412,
    47.1733450958,
    50.6996313257,
    54.2883523319,
    57.9374077040,
    61.6448652744,
    65.4089405366,
    69.2279793748,
    73.1004434553,
    77.0248977786,
    81.0000000000,
    85.0244912125,
    89.0971879449,
    93.2169751786,
    97.3828002241,
    101.5936673260,
    105.8486328899,
    110.1468012434,
    114.4873208566,
    118.8693809602,
    123.2922085109,
    127.7550654584,
    132.2572462776,
    136.7980757341,
    141.3769068557,
    145.9931190852,
    150.6461165966,
    155.3353267543,
    160.0601987021,
    164.8202020667,
    169.6148257665,
    174.4435769119,
    179.3059797911,
    184.2015749320,
    189.1299182326,
    194.0905801545,
    199.0831449737,
    204.1072100830,
    209.1623853419,
    214.2482924705,
    219.3645644828,
    224.5108451564,
    229.6867885365,
    234.8920584701,
    240.1263281692,
    245.3892798002,
    250.6806040975,
    256.0000000000,
    261.3471743083,
    266.7218413611,
    272.1237227299,
    277.5525469304,
    283.0080491495,
    288.4899709866,
    293.9980602090,
    299.5320705195,
    305.0917613358,
    310.6768975818,
    316.2872494882,
    321.9225924034,
    327.5827066139,
    333.2673771724,
    338.9763937351,
    344.7095504051,
    350.4666455847,
    356.2474818330,
    362.0518657308,
    367.8796077506,
    373.7305221334,
    379.6044267700,
    385.5011430873,
    391.4204959402,
    397.3623135070,
    403.3264271901,
    409.3126715201,
    415.3208840636,
    421.3509053358,
    427.4025787150,
    433.4757503618,
    439.5702691405,
    445.6859865441,
    451.8227566217,
    457.9804359091,
    464.1588833613,
    470.3579602882,
    476.5775302922,
    482.8174592083,
    489.0776150459,
    495.3578679332,
    501.6580900633,
    507.9781556420,
    514.3179408377,
    520.6773237328,
    527.0561842769,
    533.4544042413,
    539.8718671753,
    546.3084583636,
    552.7640647857,
    559.2385750758,
    565.7318794845,
    572.2438698415,
    578.7744395198,
    585.3234834006,
    591.8908978393,
    598.4765806331,
    605.0804309888,
    611.7023494920,
    618.3422380776,
    625.0000000000,
    631.6755398055,
    638.3687633048,
    645.0795775462,
    651.8078907899,
    658.5536124831,
    665.3166532354,
    672.0969247951,
    678.8943400262,
    685.7088128862,
    692.5402584041,
    699.3885926590,
    706.2537327602,
    713.1355968262,
    720.0341039659,
    726.9491742592,
    733.8807287386,
    740.8286893712,
    747.7929790411,
    754.7735215322,
    761.7702415115,
    768.7830645130,
    775.8119169219,
    782.8567259587,
    789.9174196648,
    796.9939268870,
    804.0861772639,
    811.1941012115,
    818.3176299096,
    825.4566952887,
    832.6112300164,
    839.7811674856,
    846.9664418012,
    854.1669877685,
    861.3827408814,
    868.6136373104,
    875.8596138918,
    883.1206081164,
    890.3965581189,
    897.6874026669,
    904.9930811514,
    912.3135335758,
    919.6487005467,
    926.9985232641,
    934.3629435117,
    941.7419036483,
    949.1353465979,
    956.5432158417,
    963.9654554089,
    971.4020098686,
    978.8528243212,
    986.3178443907,
    993.7970162163,
    1001.2902864449,
    1008.7976022234,
    1016.3189111915,
    1023.8541614739,
    1031.4033016737,
    1038.9662808647,
    1046.5430485854,
    1054.1335548314,
    1061.7377500496,
    1069.3555851309,
    1076.9870114047,
    1084.6319806319,
    1092.2904449995,
    1099.9623571140,
    1107.6476699961,
    1115.3463370744,
    1123.0583121801,
    1130.7835495416,
    1138.5220037785,
    1146.2736298969,
    1154.0383832838,
    1161.8162197020,
    1169.6070952851,
    1177.4109665328,
    1185.2277903054,
    1193.0575238198,
    1200.9001246442,
    1208.7555506939,
    1216.6237602266,
    1224.5047118380,
    1232.3983644575,
    1240.3046773436,
    1248.2236100803,
    1256.1551225723,
    1264.0991750417,
    1272.0557280230,
    1280.0247423603,
    1288.0061792024,
    1296.0000000000,
    1304.0061665011,
    1312.0246407478,
    1320.0553850728,
    1328.0983620955,
    1336.1535347188,
    1344.2208661255,
    1352.3003197751,
    1360.3918594003,
    1368.4954490040,
    1376.6110528559,
    1384.7386354892,
    1392.8781616980,
    1401.0295965338,
    1409.1929053025,
    1417.3680535619,
    1425.5550071182,
    1433.7537320236,
    1441.9641945733,
    1450.1863613025,
    1458.4201989843,
    1466.6656746263,
    1474.9227554684,
    1483.1914089801,
    1491.4716028579,
    1499.7633050227,
    1508.0664836175,
    1516.3811070048,
    1524.7071437644,
    1533.0445626906,
    1541.3933327903,
    1549.7534232806,
    1558.1248035861,
    1566.5074433375,
    1574.9013123686,
    1583.3063807145,
    1591.7226186094,
    1600.1499964846,
    1608.5884849662,
    1617.0380548732,
    1625.4986772154,
    1633.9703231917,
    1642.4529641876,
    1650.9465717736,
    1659.4511177036,
    1667.9665739122,
    1676.4929125137,
    1685.0301057998,
    1693.5781262378,
    1702.1369464690,
    1710.7065393070,
    1719.2868777356,
    1727.8779349075,
    1736.4796841426,
    1745.0920989258,
    1753.7151529063,
    1762.3488198950,
    1770.9930738636,
    1779.6478889428,
    1788.3132394207,
    1796.9890997413,
    1805.6754445031,
    1814.3722484576,
    1823.0794865074,
    1831.7971337056,
    1840.5251652535,
    1849.2635564999,
    1858.0122829390,
    1866.7713202096,
    1875.5406440938,
    1884.3202305150,
    1893.1100555371,
    1901.9100953633,
    1910.7203263343,
    1919.5407249276,
    1928.3712677557,
    1937.2119315653,
    1946.0626932359,
    1954.9235297784,
    1963.7944183344,
    1972.6753361744,
    1981.5662606973,
    1990.4671694285,
    1999.3780400196,
    2008.2988502465,
    2017.2295780088,
    2026.1702013285,
    2035.1206983489,
    2044.0810473338,
    2053.0512266659,
    2062.0312148464,
    2071.0209904936,
    2080.0205323417,
    2089.0298192403,
    2098.0488301532,
    2107.0775441570,
    2116.1159404408,
    2125.1639983049,
    2134.2216971598,
    2143.2890165253,
    2152.3659360297,
    2161.4524354089,
    2170.5484945052,
    2179.6540932666,
    2188.7692117462,
    2197.8938301007,
    2207.0279285901,
    2216.1714875766,
    2225.3244875237,
    2234.4869089955,
    2243.6587326558,
    2252.8399392674,
    2262.0305096911,
    2271.2304248850,
    2280.4396659037,
    2289.6582138977,
    2298.8860501122,
    2308.1231558868,
    2317.3695126545,
    2326.6251019409,
    2335.8899053637,
    2345.1639046317,
    2354.4470815443,
    2363.7394179907,
    2373.0408959490,
    2382.3514974860,
    2391.6712047559,
    2401.0000000000,
    2410.3378655461,
    2419.6847838074,
    2429.0407372823,
    2438.4057085534,
    2447.7796802872,
    2457.1626352330,
    2466.5545562227,
    2475.9554261700,
    2485.3652280695,
    2494.7839449968,
    2504.2115601072,
    2513.6480566352,
    2523.0934178943,
    2532.5476272760,
    2542.0106682495,
    2551.4825243609,
    2560.9631792328,
    2570.4526165636,
    2579.9508201270,
    2589.4577737714,
    2598.9734614194,
    2608.4978670675,
    2618.0309747849,
    2627.5727687136,
    2637.1232330677,
    2646.6823521328,
    2656.2501102653,
    2665.8264918923,
    2675.4114815110,
    2685.0050636878,
    2694.6072230582,
    2704.2179443264,
    2713.8372122643,
    2723.4650117115,
    2733.1013275747,
    2742.7461448270,
    2752.3994485079,
    2762.0612237221,
    2771.7314556399,
    2781.4101294962,
    2791.0972305902,
    2800.7927442847,
    2810.4966560063,
    2820.2089512442,
    2829.9296155502,
    2839.6586345385,
    2849.3959938845,
    2859.1416793251,
    2868.8956766580,
    2878.6579717413,
    2888.4285504930,
    2898.2073988909,
    2907.9945029718,
    2917.7898488313,
    2927.5934226236,
    2937.4052105607,
    2947.2251989123,
    2957.0533740053,
    2966.8897222234,
    2976.7342300070,
    2986.5868838523,
    2996.4476703115,
    3006.3165759920,
    3016.1935875562,
    3026.0786917212,
    3035.9718752584,
    3045.8731249931,
    3055.7824278041,
    3065.6997706236,
    3075.6251404365,
    3085.5585242804,
    3095.4999092450,
    3105.4492824719,
    3115.4066311543,
    3125.3719425365,
    3135.3452039137,
    3145.3264026318,
    3155.3155260867,
    3165.3125617243,
    3175.3174970403,
    3185.3303195795,
    3195.3510169356,
    3205.3795767511,
    3215.4159867169,
    3225.4602345719,
    3235.5123081028,
    3245.5721951437,
    3255.6398835758,
    3265.7153613275,
    3275.7986163735,
    3285.8896367348,
    3295.9884104787,
    3306.0949257178,
    3316.2091706107,
    3326.3311333606,
    3336.4608022160,
    3346.5981654700,
    3356.7432114599,
    3366.8959285672,
    3377.0563052172,
    3387.2243298788,
    3397.3999910641,
    3407.5832773283,
    3417.7741772695,
    3427.9726795281,
    3438.1787727870,
    3448.3924457710,
    3458.6136872466,
    3468.8424860221,
    3479.0788309468,
    3489.3227109112,
    3499.5741148464,
    3509.8330317244,
    3520.0994505573,
    3530.3733603973,
    3540.6547503364,
    3550.9436095064,
    3561.2399270783,
    3571.5436922624,
    3581.8548943078,
    3592.1735225026,
    3602.4995661730,
    3612.8330146838,
    3623.1738574377,
    3633.5220838752,
    3643.8776834744,
    3654.2406457510,
    3664.6109602577,
    3674.9886165844,
    3685.3736043574,
    3695.7659132398,
    3706.1655329312,
    3716.5724531671,
    3726.9866637191,
    3737.4081543945,
    3747.8369150361,
    3758.2729355221,
    3768.7162057659,
    3779.1667157159,
    3789.6244553551,
    3800.0894147012,
    3810.5615838063,
    3821.0409527566,
    3831.5275116724,
    3842.0212507077,
    3852.5221600504,
    3863.0302299216,
    3873.5454505757,
    3884.0678123003,
    3894.5973054159,
    3905.1339202756,
    3915.6776472653,
    3926.2284768030,
    3936.7863993390,
    3947.3514053559,
    3957.9234853677,
    3968.5026299205,
    3979.0888295917,
    3989.6820749901,
    4000.2823567557,
    4010.8896655596,
    4021.5039921036,
    4032.1253271203,
    4042.7536613729,
    4053.3889856548,
    4064.0312907898,
    4074.6805676315,
    4085.3368070638,
    4096.0000000000,
    4106.6701373831,
    4117.3472101855,
    4128.0312094089,
    4138.7221260843,
    4149.4199512713,
    4160.1246760588,
    4170.8362915639,
    4181.5547889326,
    4192.2801593392,
    4203.0123939861,
    4213.7514841039,
    4224.4974209512,
    4235.2501958144,
    4246.0098000075,
    4256.7762248721,
    4267.5494617770,
    4278.3295021186,
    4289.1163373202,
    4299.9099588321,
    4310.7103581313,
    4321.5175267219,
    4332.3314561342,
    4343.1521379251,
    4353.9795636778,
    4364.8137250016,
    4375.6546135320,
    4386.5022209304,
    4397.3565388837,
    4408.2175591050,
    4419.0852733324,
    4429.9596733298,
    4440.8407508861,
    4451.7284978156,
    4462.6229059575,
    4473.5239671759,
    4484.4316733599,
    4495.3460164231,
    4506.2669883035,
    4517.1945809640,
    4528.1287863914,
    4539.0695965968,
    4550.0170036156,
    4560.9709995068,
    4571.9315763535,
    4582.8987262626,
    4593.8724413645,
    4604.8527138130,
    4615.8395357856,
    4626.8328994828,
    4637.8327971284,
    4648.8392209693,
    4659.8521632753,
    4670.8716163390,
    4681.8975724760,
    4692.9300240243,
    4703.9689633444,
    4715.0143828193,
    4726.0662748543,
    4737.1246318771,
    4748.1894463371,
    4759.2607107062,
    4770.3384174777,
    4781.4225591672,
    4792.5131283116,
    4803.6101174696,
    4814.7135192213,
    4825.8233261683,
    4836.9395309335,
    4848.0621261609,
    4859.1911045158,
    4870.3264586842,
    4881.4681813733,
    4892.6162653110,
    4903.7707032459,
    4914.9314879474,
    4926.0986122052,
    4937.2720688295,
    4948.4518506510,
    4959.6379505206,
    4970.8303613092,
    4982.0290759079,
    4993.2340872279,
    5004.4453882001,
    5015.6629717753,
    5026.8868309241,
    5038.1169586365,
    5049.3533479223,
    5060.5959918105,
    5071.8448833497,
    5083.1000156077,
    5094.3613816714,
    5105.6289746470,
    5116.9027876595,
    5128.1828138531,
    5139.4690463907,
    5150.7614784539,
    5162.0601032433,
    5173.3649139777,
    5184.6759038949,
    5195.9930662506,
    5207.3163943194,
    5218.6458813939,
    5229.9815207850,
    5241.3233058217,
    5252.6712298510,
    5264.0252862380,
    5275.3854683656,
    5286.7517696346,
    5298.1241834635,
    5309.5027032884,
    5320.8873225631,
    5332.2780347590,
    5343.6748333647,
    5355.0777118863,
    5366.4866638472,
    5377.9016827880,
    5389.3227622665,
    5400.7498958574,
    5412.1830771527,
    5423.6222997611,
    5435.0675573082,
    5446.5188434364,
    5457.9761518049,
    5469.4394760894,
    5480.9088099822,
    5492.3841471923,
    5503.8654814448,
    5515.3528064816,
    5526.8461160606,
    5538.3454039558,
    5549.8506639579,
    5561.3618898731,
    5572.8790755240,
    5584.4022147491,
    5595.9313014028,
    5607.4663293552,
    5619.0072924923,
    5630.5541847159,
    5642.1069999431,
    5653.6657321070,
    5665.2303751559,
    5676.8009230538,
    5688.3773697797,
    5699.9597093284,
    5711.5479357096,
    5723.1420429485,
    5734.7420250850,
    5746.3478761746,
    5757.9595902874,
    5769.5771615087,
    5781.2005839386,
    5792.8298516920,
    5804.4649588987,
    5816.1058997031,
    5827.7526682643,
    5839.4052587560,
    5851.0636653664,
    5862.7278822983,
    5874.3979037688,
    5886.0737240093,
    5897.7553372658,
    5909.4427377983,
    5921.1359198811,
    5932.8348778025,
    5944.5396058651,
    5956.2500983854,
    5967.9663496940,
    5979.6883541351,
    5991.4161060672,
    6003.1495998623,
    6014.8888299063,
    6026.6337905987,
    6038.3844763527,
    6050.1408815952,
    6061.9030007664,
    6073.6708283203,
    6085.4443587241,
    6097.2235864585,
    6109.0085060174,
    6120.7991119082,
    6132.5953986513,
    6144.3973607806,
    6156.2049928426,
    6168.0182893975,
    6179.8372450182,
    6191.6618542904,
    6203.4921118132,
    6215.3280121982,
    6227.1695500700,
    6239.0167200659,
    6250.8695168361,
    6262.7279350432,
    6274.5919693627,
    6286.4616144826,
    6298.3368651034,
    6310.2177159382,
    6322.1041617124,
    6333.9961971640,
    6345.8938170431,
    6357.7970161124,
    6369.7057891466,
    6381.6201309327,
    6393.5400362700,
    6405.4654999698,
    6417.3965168555,
    6429.3330817625,
    6441.2751895383,
    6453.2228350423,
    6465.1760131457,
    6477.1347187317,
    6489.0989466952,
    6501.0686919430,
    6513.0439493936,
    6525.0247139769,
    6537.0109806350,
    6549.0027443210,
    6561.0000000000,
    6573.0027426484,
    6585.0109672541,
    6597.0246688165,
    6609.0438423464,
    6621.0684828657,
    6633.0985854079,
    6645.1341450177,
    6657.1751567510,
    6669.2216156747,
    6681.2735168671,
    6693.3308554176,
    6705.3936264265,
    6717.4618250051,
    6729.5354462759,
    6741.6144853722,
    6753.6989374383,
    6765.7887976291,
    6777.8840611107,
    6789.9847230597,
    6802.0907786636,
    6814.2022231205,
    6826.3190516394,
    6838.4412594396,
    6850.5688417513,
    6862.7017938151,
    6874.8401108821,
    6886.9837882140,
    6899.1328210829,
    6911.2872047712,
    6923.4469345719,
    6935.6120057882,
    6947.7824137335,
    6959.9581537318,
    6972.1392211169,
    6984.3256112330,
    6996.5173194347,
    7008.7143410863,
    7020.9166715624,
    7033.1243062477,
    7045.3372405367,
    7057.5554698343,
    7069.7789895548,
    7082.0077951229,
    7094.2418819728,
    7106.4812455489,
    7118.7258813051,
    7130.9757847053,
    7143.2309512230,
    7155.4913763416,
    7167.7570555538,
    7180.0279843624,
    7192.3041582795,
    7204.5855728270,
    7216.8722235361,
    7229.1641059476,
    7241.4612156120,
    7253.7635480891,
    7266.0710989478,
    7278.3838637670,
    7290.7018381344,
    7303.0250176474,
    7315.3533979125,
    7327.6869745455,
    7340.0257431713,
    7352.3696994244,
    7364.7188389480,
    7377.0731573946,
    7389.4326504259,
    7401.7973137127,
    7414.1671429346,
    7426.5421337804,
    7438.9222819480,
    7451.3075831438,
    7463.6980330837,
    7476.0936274921,
    7488.4943621024,
    7500.9002326569,
    7513.3112349065,
    7525.7273646110,
    7538.1486175390,
    7550.5749894679,
    7563.0064761834,
    7575.4430734804,
    7587.8847771619,
    7600.3315830400,
    7612.7834869349,
    7625.2404846758,
    7637.7025721001,
    7650.1697450538,
    7662.6419993914,
    7675.1193309757,
    7687.6017356782,
    7700.0892093785,
    7712.5817479647,
    7725.0793473331,
    7737.5820033885,
    7750.0897120437,
    7762.6024692201,
    7775.1202708469,
    7787.6431128620,
    7800.1709912110,
    7812.7039018478,
    7825.2418407347,
    7837.7848038416,
    7850.3327871468,
    7862.8857866366,
    7875.4437983052,
    7888.0068181548,
    7900.5748421957,
    7913.1478664460,
    7925.7258869318,
    7938.3088996870,
    7950.8969007534,
    7963.4898861807,
    7976.0878520263,
    7988.6907943555,
    8001.2987092412,
    8013.9115927643,
    8026.5294410131,
    8039.1522500838,
    8051.7800160802,
    8064.4127351138,
    8077.0504033037,
    8089.6930167764,
    8102.3405716663,
    8114.9930641151,
    8127.6504902721,
    8140.3128462940,
    8152.9801283453,
    8165.6523325976,
    8178.3294552300,
    8191.0114924292,
    8203.6984403890,
    8216.3902953107,
    8229.0870534031,
    8241.7887108821,
    8254.4952639709,
    8267.2067089000,
    8279.9230419073,
    8292.6442592376,
    8305.3703571432,
    8318.1013318835,
    8330.8371797251,
    8343.5778969415,
    8356.3234798136,
    8369.0739246292,
    8381.8292276834,
    8394.5893852780,
    8407.3543937222,
    8420.1242493321,
    8432.8989484305,
    8445.6784873475,
    8458.4628624202,
    8471.2520699922,
    8484.0461064144,
    8496.8449680444,
    8509.6486512468,
    8522.4571523928,
    8535.2704678607,
    8548.0885940353,
    8560.9115273086,
    8573.7392640788,
    8586.5718007514,
    8599.4091337382,
    8612.2512594579,
    8625.0981743359,
    8637.9498748040,
    8650.8063573010,
    8663.6676182722,
    8676.5336541692,
    8689.4044614507,
    8702.2800365815,
    8715.1603760331,
    8728.0454762838,
    8740.9353338178,
    8753.8299451264,
    8766.7293067070,
    8779.6334150636,
    8792.5422667064,
    8805.4558581523,
    8818.3741859245,
    8831.2972465524,
    8844.2250365719,
    8857.1575525253,
    8870.0947909611,
    8883.0367484340,
    8895.9834215053,
    8908.9348067421,
    8921.8909007182,
    8934.8517000133,
    8947.8172012135,
    8960.7874009109,
    8973.7622957040,
    8986.7418821972,
    8999.7261570012,
    9012.7151167328,
    9025.7087580148,
    9038.7070774762,
    9051.7100717521,
    9064.7177374833,
    9077.7300713171,
    9090.7470699065,
    9103.7687299106,
    9116.7950479945,
    9129.8260208291,
    9142.8616450914,
    9155.9019174644,
    9168.9468346367,
    9181.9963933031,
    9195.0505901642,
    9208.1094219263,
    9221.1728853017,
    9234.2409770084,
    9247.3136937704,
    9260.3910323173,
    9273.4729893846,
    9286.5595617135,
    9299.6507460510,
    9312.7465391496,
    9325.8469377679,
    9338.9519386698,
    9352.0615386252,
    9365.1757344094,
    9378.2945228036,
    9391.4179005944,
    9404.5458645741,
    9417.6784115407,
    9430.8155382977,
    9443.9572416540,
    9457.1035184244,
    9470.2543654290,
    9483.4097794934,
    9496.5697574489,
    9509.7342961321,
    9522.9033923851,
    9536.0770430556,
    9549.2552449966,
    9562.4379950666,
    9575.6252901295,
    9588.8171270546,
    9602.0135027165,
    9615.2144139955,
    9628.4198577767,
    9641.6298309511,
    9654.8443304146,
    9668.0633530688,
    9681.2868958202,
    9694.5149555808,
    9707.7475292679,
    9720.9846138040,
    9734.2262061168,
    9747.4723031393,
    9760.7229018097,
    9773.9779990712,
    9787.2375918726,
    9800.5016771674,
    9813.7702519147,
    9827.0433130783,
    9840.3208576275,
    9853.6028825365,
    9866.8893847847,
    9880.1803613565,
    9893.4758092415,
    9906.7757254342,
    9920.0801069342,
    9933.3889507462,
    9946.7022538799,
    9960.0200133500,
    9973.3422261761,
    9986.6688893829,
    10000.0000000000,
    10013.3355550619,
    10026.6755516082,
    10040.0199866833,
    10053.3688573365,
    10066.7221606221,
    10080.0798935991,
    10093.4420533317,
    10106.8086368886,
    10120.1796413436,
    10133.5550637751,
    10146.9349012666,
    10160.3191509062,
    10173.7078097869,
    10187.1008750065,
    10200.4983436674,
    10213.9002128770,
    10227.3064797472,
    10240.7171413949,
    10254.1321949415,
    10267.5516375131,
    10280.9754662408,
    10294.4036782600,
    10307.8362707111,
    10321.2732407388,
    10334.7145854928
};

#else

static real_t iq_table[] =
{
    REAL_CONST(0.0000000000/8),
    REAL_CONST(1.0000000000/8),
    REAL_CONST(2.5198421478/8),
    REAL_CONST(4.3267488480/8),
    REAL_CONST(6.3496041298/8),
    REAL_CONST(8.5498800278/8),
    REAL_CONST(10.9027233124/8),
    REAL_CONST(13.3905181885/8),
    REAL_CONST(16.0000000000/8),
    REAL_CONST(18.7207546234/8),
    REAL_CONST(21.5443477631/8),
    REAL_CONST(24.4637813568/8),
    REAL_CONST(27.4731426239/8),
    REAL_CONST(30.5673503876/8),
    REAL_CONST(33.7419929504/8),
    REAL_CONST(36.9931793213/8),
    REAL_CONST(40.3174743652/8),
    REAL_CONST(43.7117881775/8),
    REAL_CONST(47.1733436584/8),
    REAL_CONST(50.6996307373/8),
    REAL_CONST(54.2883529663/8),
    REAL_CONST(57.9374084473/8),
    REAL_CONST(61.6448669434/8),
    REAL_CONST(65.4089431763/8),
    REAL_CONST(69.2279815674/8),
    REAL_CONST(73.1004409790/8),
    REAL_CONST(77.0248947144/8),
    REAL_CONST(81.0000000000/8),
    REAL_CONST(85.0244903564/8),
    REAL_CONST(89.0971908569/8),
    REAL_CONST(93.2169723511/8),
    REAL_CONST(97.3827972412/8),
    REAL_CONST(101.5936660767/8),
    REAL_CONST(105.8486328125/8),
    REAL_CONST(110.1468048096/8),
    REAL_CONST(114.4873199463/8),
    REAL_CONST(118.8693847656/8),
    REAL_CONST(123.2922058105/8),
    REAL_CONST(127.7550659180/8),
    REAL_CONST(132.2572479248/8),
    REAL_CONST(136.7980804443/8),
    REAL_CONST(141.3769073486/8),
    REAL_CONST(145.9931182861/8),
    REAL_CONST(150.6461181641/8),
    REAL_CONST(155.3353271484/8),
    REAL_CONST(160.0601959229/8),
    REAL_CONST(164.8202056885/8),
    REAL_CONST(169.6148223877/8),
    REAL_CONST(174.4435729980/8),
    REAL_CONST(179.3059844971/8),
    REAL_CONST(184.2015686035/8),
    REAL_CONST(189.1299133301/8),
    REAL_CONST(194.0905761719/8),
    REAL_CONST(199.0831451416/8),
    REAL_CONST(204.1072082520/8),
    REAL_CONST(209.1623840332/8),
    REAL_CONST(214.2482910156/8),
    REAL_CONST(219.3645629883/8),
    REAL_CONST(224.5108489990/8),
    REAL_CONST(229.6867828369/8),
    REAL_CONST(234.8920593262/8),
    REAL_CONST(240.1263275146/8),
    REAL_CONST(245.3892822266/8),
    REAL_CONST(250.6806030273/8),
    REAL_CONST(256.0000000000/8),
    REAL_CONST(261.3471679688/8),
    REAL_CONST(266.7218322754/8),
    REAL_CONST(272.1237182617/8),
    REAL_CONST(277.5525512695/8),
    REAL_CONST(283.0080566406/8),
    REAL_CONST(288.4899597168/8),
    REAL_CONST(293.9980468750/8),
    REAL_CONST(299.5320739746/8),
    REAL_CONST(305.0917663574/8),
    REAL_CONST(310.6769104004/8),
    REAL_CONST(316.2872619629/8),
    REAL_CONST(321.9226074219/8),
    REAL_CONST(327.5827026367/8),
    REAL_CONST(333.2673645020/8),
    REAL_CONST(338.9763793945/8),
    REAL_CONST(344.7095642090/8),
    REAL_CONST(350.4666442871/8),
    REAL_CONST(356.2474670410/8),
    REAL_CONST(362.0518798828/8),
    REAL_CONST(367.8796081543/8),
    REAL_CONST(373.7305297852/8),
    REAL_CONST(379.6044311523/8),
    REAL_CONST(385.5011291504/8),
    REAL_CONST(391.4205017090/8),
    REAL_CONST(397.3623046875/8),
    REAL_CONST(403.3264160156/8),
    REAL_CONST(409.3126831055/8),
    REAL_CONST(415.3208923340/8),
    REAL_CONST(421.3508911133/8),
    REAL_CONST(427.4025878906/8),
    REAL_CONST(433.4757385254/8),
    REAL_CONST(439.5702819824/8),
    REAL_CONST(445.6859741211/8),
    REAL_CONST(451.8227539063/8),
    REAL_CONST(457.9804382324/8),
    REAL_CONST(464.1588745117/8),
    REAL_CONST(470.3579711914/8),
    REAL_CONST(476.5775451660/8),
    REAL_CONST(482.8174743652/8),
    REAL_CONST(489.0776062012/8),
    REAL_CONST(495.3578796387/8),
    REAL_CONST(501.6580810547/8),
    REAL_CONST(507.9781494141/8),
    REAL_CONST(514.3179321289/8),
    REAL_CONST(520.6773071289/8),
    REAL_CONST(527.0562133789/8),
    REAL_CONST(533.4544067383/8),
    REAL_CONST(539.8718872070/8),
    REAL_CONST(546.3084716797/8),
    REAL_CONST(552.7640380859/8),
    REAL_CONST(559.2385864258/8),
    REAL_CONST(565.7318725586/8),
    REAL_CONST(572.2438964844/8),
    REAL_CONST(578.7744140625/8),
    REAL_CONST(585.3234863281/8),
    REAL_CONST(591.8908691406/8),
    REAL_CONST(598.4765625000/8),
    REAL_CONST(605.0804443359/8),
    REAL_CONST(611.7023315430/8),
    REAL_CONST(618.3422241211/8),
    REAL_CONST(625.0000000000/8),
    REAL_CONST(631.6755371094/8),
    REAL_CONST(638.3687744141/8),
    REAL_CONST(645.0795898438/8),
    REAL_CONST(651.8078613281/8),
    REAL_CONST(658.5535888672/8),
    REAL_CONST(665.3166503906/8),
    REAL_CONST(672.0969238281/8),
    REAL_CONST(678.8943481445/8),
    REAL_CONST(685.7088012695/8),
    REAL_CONST(692.5402832031/8),
    REAL_CONST(699.3886108398/8),
    REAL_CONST(706.2537231445/8),
    REAL_CONST(713.1356201172/8),
    REAL_CONST(720.0341186523/8),
    REAL_CONST(726.9491577148/8),
    REAL_CONST(733.8807373047/8),
    REAL_CONST(740.8286743164/8),
    REAL_CONST(747.7929687500/8),
    REAL_CONST(754.7734985352/8),
    REAL_CONST(761.7702636719/8),
    REAL_CONST(768.7830810547/8),
    REAL_CONST(775.8118896484/8),
    REAL_CONST(782.8567504883/8),
    REAL_CONST(789.9174194336/8),
    REAL_CONST(796.9938964844/8),
    REAL_CONST(804.0861816406/8),
    REAL_CONST(811.1940917969/8),
    REAL_CONST(818.3176269531/8),
    REAL_CONST(825.4566650391/8),
    REAL_CONST(832.6112060547/8),
    REAL_CONST(839.7811889648/8),
    REAL_CONST(846.9664306641/8),
    REAL_CONST(854.1669921875/8),
    REAL_CONST(861.3827514648/8),
    REAL_CONST(868.6136474609/8),
    REAL_CONST(875.8596191406/8),
    REAL_CONST(883.1206054688/8),
    REAL_CONST(890.3965454102/8),
    REAL_CONST(897.6873779297/8),
    REAL_CONST(904.9931030273/8),
    REAL_CONST(912.3135375977/8),
    REAL_CONST(919.6486816406/8),
    REAL_CONST(926.9985351563/8),
    REAL_CONST(934.3629150391/8),
    REAL_CONST(941.7418823242/8),
    REAL_CONST(949.1353759766/8),
    REAL_CONST(956.5432128906/8),
    REAL_CONST(963.9654541016/8),
    REAL_CONST(971.4020385742/8),
    REAL_CONST(978.8528442383/8),
    REAL_CONST(986.3178710938/8),
    REAL_CONST(993.7969970703/8),
    REAL_CONST(1001.2902832031/8),
    REAL_CONST(1008.7976074219/8),
    REAL_CONST(1016.3189086914/8),
    REAL_CONST(1023.8541870117/8),
    REAL_CONST(1031.4033203125/8),
    REAL_CONST(1038.9663085938/8),
    REAL_CONST(1046.5430908203/8),
    REAL_CONST(1054.1335449219/8),
    REAL_CONST(1061.7377929688/8),
    REAL_CONST(1069.3555908203/8),
    REAL_CONST(1076.9870605469/8),
    REAL_CONST(1084.6319580078/8),
    REAL_CONST(1092.2904052734/8),
    REAL_CONST(1099.9624023438/8),
    REAL_CONST(1107.6477050781/8),
    REAL_CONST(1115.3463134766/8),
    REAL_CONST(1123.0583496094/8),
    REAL_CONST(1130.7835693359/8),
    REAL_CONST(1138.5219726563/8),
    REAL_CONST(1146.2736816406/8),
    REAL_CONST(1154.0383300781/8),
    REAL_CONST(1161.8161621094/8),
    REAL_CONST(1169.6070556641/8),
    REAL_CONST(1177.4110107422/8),
    REAL_CONST(1185.2277832031/8),
    REAL_CONST(1193.0574951172/8),
    REAL_CONST(1200.9001464844/8),
    REAL_CONST(1208.7554931641/8),
    REAL_CONST(1216.6237792969/8),
    REAL_CONST(1224.5047607422/8),
    REAL_CONST(1232.3983154297/8),
    REAL_CONST(1240.3046875000/8),
    REAL_CONST(1248.2236328125/8),
    REAL_CONST(1256.1551513672/8),
    REAL_CONST(1264.0991210938/8),
    REAL_CONST(1272.0557861328/8),
    REAL_CONST(1280.0247802734/8),
    REAL_CONST(1288.0062255859/8),
    REAL_CONST(1296.0000000000/8),
    REAL_CONST(1304.0062255859/8),
    REAL_CONST(1312.0246582031/8),
    REAL_CONST(1320.0554199219/8),
    REAL_CONST(1328.0983886719/8),
    REAL_CONST(1336.1535644531/8),
    REAL_CONST(1344.2208251953/8),
    REAL_CONST(1352.3002929688/8),
    REAL_CONST(1360.3918457031/8),
    REAL_CONST(1368.4954833984/8),
    REAL_CONST(1376.6110839844/8),
    REAL_CONST(1384.7386474609/8),
    REAL_CONST(1392.8781738281/8),
    REAL_CONST(1401.0295410156/8),
    REAL_CONST(1409.1928710938/8),
    REAL_CONST(1417.3680419922/8),
    REAL_CONST(1425.5550537109/8),
    REAL_CONST(1433.7537841797/8),
    REAL_CONST(1441.9642333984/8),
    REAL_CONST(1450.1864013672/8),
    REAL_CONST(1458.4201660156/8),
    REAL_CONST(1466.6656494141/8),
    REAL_CONST(1474.9227294922/8),
    REAL_CONST(1483.1914062500/8),
    REAL_CONST(1491.4715576172/8),
    REAL_CONST(1499.7633056641/8),
    REAL_CONST(1508.0665283203/8),
    REAL_CONST(1516.3811035156/8),
    REAL_CONST(1524.7071533203/8),
    REAL_CONST(1533.0445556641/8),
    REAL_CONST(1541.3933105469/8),
    REAL_CONST(1549.7534179688/8),
    REAL_CONST(1558.1247558594/8),
    REAL_CONST(1566.5074462891/8),
    REAL_CONST(1574.9013671875/8),
    REAL_CONST(1583.3063964844/8),
    REAL_CONST(1591.7226562500/8),
    REAL_CONST(1600.1500244141/8),
    REAL_CONST(1608.5885009766/8),
    REAL_CONST(1617.0380859375/8),
    REAL_CONST(1625.4986572266/8),
    REAL_CONST(1633.9703369141/8),
    REAL_CONST(1642.4530029297/8),
    REAL_CONST(1650.9465332031/8),
    REAL_CONST(1659.4511718750/8),
    REAL_CONST(1667.9665527344/8),
    REAL_CONST(1676.4929199219/8),
    REAL_CONST(1685.0301513672/8),
    REAL_CONST(1693.5781250000/8),
    REAL_CONST(1702.1369628906/8),
    REAL_CONST(1710.7065429688/8),
    REAL_CONST(1719.2868652344/8),
    REAL_CONST(1727.8779296875/8),
    REAL_CONST(1736.4797363281/8),
    REAL_CONST(1745.0920410156/8),
    REAL_CONST(1753.7152099609/8),
    REAL_CONST(1762.3488769531/8),
    REAL_CONST(1770.9930419922/8),
    REAL_CONST(1779.6479492188/8),
    REAL_CONST(1788.3132324219/8),
    REAL_CONST(1796.9891357422/8),
    REAL_CONST(1805.6754150391/8),
    REAL_CONST(1814.3721923828/8),
    REAL_CONST(1823.0794677734/8),
    REAL_CONST(1831.7971191406/8),
    REAL_CONST(1840.5251464844/8),
    REAL_CONST(1849.2635498047/8),
    REAL_CONST(1858.0123291016/8),
    REAL_CONST(1866.7713623047/8),
    REAL_CONST(1875.5406494141/8),
    REAL_CONST(1884.3201904297/8),
    REAL_CONST(1893.1101074219/8),
    REAL_CONST(1901.9101562500/8),
    REAL_CONST(1910.7203369141/8),
    REAL_CONST(1919.5407714844/8),
    REAL_CONST(1928.3712158203/8),
    REAL_CONST(1937.2119140625/8),
    REAL_CONST(1946.0627441406/8),
    REAL_CONST(1954.9235839844/8),
    REAL_CONST(1963.7944335938/8),
    REAL_CONST(1972.6752929688/8),
    REAL_CONST(1981.5662841797/8),
    REAL_CONST(1990.4671630859/8),
    REAL_CONST(1999.3780517578/8),
    REAL_CONST(2008.2988281250/8),
    REAL_CONST(2017.2296142578/8),
    REAL_CONST(2026.1701660156/8),
    REAL_CONST(2035.1207275391/8),
    REAL_CONST(2044.0810546875/8),
    REAL_CONST(2053.0512695313/8),
    REAL_CONST(2062.0312500000/8),
    REAL_CONST(2071.0209960938/8),
    REAL_CONST(2080.0205078125/8),
    REAL_CONST(2089.0297851563/8),
    REAL_CONST(2098.0488281250/8),
    REAL_CONST(2107.0776367188/8),
    REAL_CONST(2116.1159667969/8),
    REAL_CONST(2125.1640625000/8),
    REAL_CONST(2134.2216796875/8),
    REAL_CONST(2143.2890625000/8),
    REAL_CONST(2152.3659667969/8),
    REAL_CONST(2161.4523925781/8),
    REAL_CONST(2170.5485839844/8),
    REAL_CONST(2179.6540527344/8),
    REAL_CONST(2188.7692871094/8),
    REAL_CONST(2197.8937988281/8),
    REAL_CONST(2207.0278320313/8),
    REAL_CONST(2216.1713867188/8),
    REAL_CONST(2225.3244628906/8),
    REAL_CONST(2234.4868164063/8),
    REAL_CONST(2243.6586914063/8),
    REAL_CONST(2252.8398437500/8),
    REAL_CONST(2262.0305175781/8),
    REAL_CONST(2271.2304687500/8),
    REAL_CONST(2280.4396972656/8),
    REAL_CONST(2289.6582031250/8),
    REAL_CONST(2298.8859863281/8),
    REAL_CONST(2308.1230468750/8),
    REAL_CONST(2317.3696289063/8),
    REAL_CONST(2326.6250000000/8),
    REAL_CONST(2335.8898925781/8),
    REAL_CONST(2345.1638183594/8),
    REAL_CONST(2354.4470214844/8),
    REAL_CONST(2363.7395019531/8),
    REAL_CONST(2373.0410156250/8),
    REAL_CONST(2382.3515625000/8),
    REAL_CONST(2391.6711425781/8),
    REAL_CONST(2401.0000000000/8),
    REAL_CONST(2410.3378906250/8),
    REAL_CONST(2419.6848144531/8),
    REAL_CONST(2429.0407714844/8),
    REAL_CONST(2438.4057617188/8),
    REAL_CONST(2447.7797851563/8),
    REAL_CONST(2457.1625976563/8),
    REAL_CONST(2466.5544433594/8),
    REAL_CONST(2475.9553222656/8),
    REAL_CONST(2485.3652343750/8),
    REAL_CONST(2494.7839355469/8),
    REAL_CONST(2504.2116699219/8),
    REAL_CONST(2513.6479492188/8),
    REAL_CONST(2523.0935058594/8),
    REAL_CONST(2532.5476074219/8),
    REAL_CONST(2542.0107421875/8),
    REAL_CONST(2551.4824218750/8),
    REAL_CONST(2560.9631347656/8),
    REAL_CONST(2570.4526367188/8),
    REAL_CONST(2579.9509277344/8),
    REAL_CONST(2589.4577636719/8),
    REAL_CONST(2598.9733886719/8),
    REAL_CONST(2608.4978027344/8),
    REAL_CONST(2618.0310058594/8),
    REAL_CONST(2627.5727539063/8),
    REAL_CONST(2637.1232910156/8),
    REAL_CONST(2646.6823730469/8),
    REAL_CONST(2656.2500000000/8),
    REAL_CONST(2665.8264160156/8),
    REAL_CONST(2675.4113769531/8),
    REAL_CONST(2685.0051269531/8),
    REAL_CONST(2694.6071777344/8),
    REAL_CONST(2704.2180175781/8),
    REAL_CONST(2713.8371582031/8),
    REAL_CONST(2723.4650878906/8),
    REAL_CONST(2733.1013183594/8),
    REAL_CONST(2742.7460937500/8),
    REAL_CONST(2752.3994140625/8),
    REAL_CONST(2762.0612792969/8),
    REAL_CONST(2771.7314453125/8),
    REAL_CONST(2781.4101562500/8),
    REAL_CONST(2791.0971679688/8),
    REAL_CONST(2800.7927246094/8),
    REAL_CONST(2810.4965820313/8),
    REAL_CONST(2820.2089843750/8),
    REAL_CONST(2829.9296875000/8),
    REAL_CONST(2839.6586914063/8),
    REAL_CONST(2849.3959960938/8),
    REAL_CONST(2859.1416015625/8),
    REAL_CONST(2868.8957519531/8),
    REAL_CONST(2878.6579589844/8),
    REAL_CONST(2888.4284667969/8),
    REAL_CONST(2898.2075195313/8),
    REAL_CONST(2907.9943847656/8),
    REAL_CONST(2917.7897949219/8),
    REAL_CONST(2927.5935058594/8),
    REAL_CONST(2937.4052734375/8),
    REAL_CONST(2947.2250976563/8),
    REAL_CONST(2957.0534667969/8),
    REAL_CONST(2966.8896484375/8),
    REAL_CONST(2976.7341308594/8),
    REAL_CONST(2986.5869140625/8),
    REAL_CONST(2996.4477539063/8),
    REAL_CONST(3006.3166503906/8),
    REAL_CONST(3016.1936035156/8),
    REAL_CONST(3026.0786132813/8),
    REAL_CONST(3035.9719238281/8),
    REAL_CONST(3045.8730468750/8),
    REAL_CONST(3055.7824707031/8),
    REAL_CONST(3065.6997070313/8),
    REAL_CONST(3075.6252441406/8),
    REAL_CONST(3085.5585937500/8),
    REAL_CONST(3095.5000000000/8),
    REAL_CONST(3105.4492187500/8),
    REAL_CONST(3115.4067382813/8),
    REAL_CONST(3125.3718261719/8),
    REAL_CONST(3135.3452148438/8),
    REAL_CONST(3145.3264160156/8),
    REAL_CONST(3155.3154296875/8),
    REAL_CONST(3165.3125000000/8),
    REAL_CONST(3175.3173828125/8),
    REAL_CONST(3185.3303222656/8),
    REAL_CONST(3195.3510742188/8),
    REAL_CONST(3205.3796386719/8),
    REAL_CONST(3215.4160156250/8),
    REAL_CONST(3225.4602050781/8),
    REAL_CONST(3235.5122070313/8),
    REAL_CONST(3245.5722656250/8),
    REAL_CONST(3255.6398925781/8),
    REAL_CONST(3265.7153320313/8),
    REAL_CONST(3275.7985839844/8),
    REAL_CONST(3285.8896484375/8),
    REAL_CONST(3295.9885253906/8),
    REAL_CONST(3306.0949707031/8),
    REAL_CONST(3316.2092285156/8),
    REAL_CONST(3326.3310546875/8),
    REAL_CONST(3336.4606933594/8),
    REAL_CONST(3346.5981445313/8),
    REAL_CONST(3356.7431640625/8),
    REAL_CONST(3366.8959960938/8),
    REAL_CONST(3377.0563964844/8),
    REAL_CONST(3387.2243652344/8),
    REAL_CONST(3397.3999023438/8),
    REAL_CONST(3407.5832519531/8),
    REAL_CONST(3417.7741699219/8),
    REAL_CONST(3427.9726562500/8),
    REAL_CONST(3438.1787109375/8),
    REAL_CONST(3448.3923339844/8),
    REAL_CONST(3458.6137695313/8),
    REAL_CONST(3468.8425292969/8),
    REAL_CONST(3479.0788574219/8),
    REAL_CONST(3489.3227539063/8),
    REAL_CONST(3499.5742187500/8),
    REAL_CONST(3509.8330078125/8),
    REAL_CONST(3520.0993652344/8),
    REAL_CONST(3530.3732910156/8),
    REAL_CONST(3540.6547851563/8),
    REAL_CONST(3550.9436035156/8),
    REAL_CONST(3561.2399902344/8),
    REAL_CONST(3571.5437011719/8),
    REAL_CONST(3581.8549804688/8),
    REAL_CONST(3592.1735839844/8),
    REAL_CONST(3602.4995117188/8),
    REAL_CONST(3612.8330078125/8),
    REAL_CONST(3623.1738281250/8),
    REAL_CONST(3633.5219726563/8),
    REAL_CONST(3643.8776855469/8),
    REAL_CONST(3654.2407226563/8),
    REAL_CONST(3664.6108398438/8),
    REAL_CONST(3674.9885253906/8),
    REAL_CONST(3685.3735351563/8),
    REAL_CONST(3695.7658691406/8),
    REAL_CONST(3706.1655273438/8),
    REAL_CONST(3716.5725097656/8),
    REAL_CONST(3726.9865722656/8),
    REAL_CONST(3737.4082031250/8),
    REAL_CONST(3747.8369140625/8),
    REAL_CONST(3758.2729492188/8),
    REAL_CONST(3768.7163085938/8),
    REAL_CONST(3779.1667480469/8),
    REAL_CONST(3789.6245117188/8),
    REAL_CONST(3800.0893554688/8),
    REAL_CONST(3810.5615234375/8),
    REAL_CONST(3821.0410156250/8),
    REAL_CONST(3831.5275878906/8),
    REAL_CONST(3842.0212402344/8),
    REAL_CONST(3852.5222167969/8),
    REAL_CONST(3863.0302734375/8),
    REAL_CONST(3873.5454101563/8),
    REAL_CONST(3884.0678710938/8),
    REAL_CONST(3894.5974121094/8),
    REAL_CONST(3905.1340332031/8),
    REAL_CONST(3915.6777343750/8),
    REAL_CONST(3926.2285156250/8),
    REAL_CONST(3936.7863769531/8),
    REAL_CONST(3947.3513183594/8),
    REAL_CONST(3957.9235839844/8),
    REAL_CONST(3968.5026855469/8),
    REAL_CONST(3979.0888671875/8),
    REAL_CONST(3989.6821289063/8),
    REAL_CONST(4000.2824707031/8),
    REAL_CONST(4010.8896484375/8),
    REAL_CONST(4021.5039062500/8),
    REAL_CONST(4032.1252441406/8),
    REAL_CONST(4042.7536621094/8),
    REAL_CONST(4053.3889160156/8),
    REAL_CONST(4064.0312500000/8),
    REAL_CONST(4074.6806640625/8),
    REAL_CONST(4085.3369140625/8),
    REAL_CONST(4096.0000000000/8),
    REAL_CONST(4106.6699218750/8),
    REAL_CONST(4117.3471679688/8),
    REAL_CONST(4128.0312500000/8),
    REAL_CONST(4138.7221679688/8),
    REAL_CONST(4149.4199218750/8),
    REAL_CONST(4160.1245117188/8),
    REAL_CONST(4170.8364257813/8),
    REAL_CONST(4181.5546875000/8),
    REAL_CONST(4192.2802734375/8),
    REAL_CONST(4203.0122070313/8),
    REAL_CONST(4213.7514648438/8),
    REAL_CONST(4224.4975585938/8),
    REAL_CONST(4235.2500000000/8),
    REAL_CONST(4246.0097656250/8),
    REAL_CONST(4256.7763671875/8),
    REAL_CONST(4267.5493164063/8),
    REAL_CONST(4278.3295898438/8),
    REAL_CONST(4289.1162109375/8),
    REAL_CONST(4299.9101562500/8),
    REAL_CONST(4310.7104492188/8),
    REAL_CONST(4321.5175781250/8),
    REAL_CONST(4332.3315429688/8),
    REAL_CONST(4343.1523437500/8),
    REAL_CONST(4353.9794921875/8),
    REAL_CONST(4364.8139648438/8),
    REAL_CONST(4375.6547851563/8),
    REAL_CONST(4386.5024414063/8),
    REAL_CONST(4397.3564453125/8),
    REAL_CONST(4408.2177734375/8),
    REAL_CONST(4419.0854492188/8),
    REAL_CONST(4429.9594726563/8),
    REAL_CONST(4440.8408203125/8),
    REAL_CONST(4451.7285156250/8),
    REAL_CONST(4462.6230468750/8),
    REAL_CONST(4473.5239257813/8),
    REAL_CONST(4484.4316406250/8),
    REAL_CONST(4495.3461914063/8),
    REAL_CONST(4506.2670898438/8),
    REAL_CONST(4517.1948242188/8),
    REAL_CONST(4528.1289062500/8),
    REAL_CONST(4539.0698242188/8),
    REAL_CONST(4550.0170898438/8),
    REAL_CONST(4560.9711914063/8),
    REAL_CONST(4571.9316406250/8),
    REAL_CONST(4582.8989257813/8),
    REAL_CONST(4593.8725585938/8),
    REAL_CONST(4604.8525390625/8),
    REAL_CONST(4615.8393554688/8),
    REAL_CONST(4626.8330078125/8),
    REAL_CONST(4637.8330078125/8),
    REAL_CONST(4648.8393554688/8),
    REAL_CONST(4659.8520507813/8),
    REAL_CONST(4670.8715820313/8),
    REAL_CONST(4681.8974609375/8),
    REAL_CONST(4692.9301757813/8),
    REAL_CONST(4703.9687500000/8),
    REAL_CONST(4715.0141601563/8),
    REAL_CONST(4726.0664062500/8),
    REAL_CONST(4737.1245117188/8),
    REAL_CONST(4748.1894531250/8),
    REAL_CONST(4759.2607421875/8),
    REAL_CONST(4770.3383789063/8),
    REAL_CONST(4781.4223632813/8),
    REAL_CONST(4792.5131835938/8),
    REAL_CONST(4803.6103515625/8),
    REAL_CONST(4814.7133789063/8),
    REAL_CONST(4825.8232421875/8),
    REAL_CONST(4836.9394531250/8),
    REAL_CONST(4848.0620117188/8),
    REAL_CONST(4859.1909179688/8),
    REAL_CONST(4870.3266601563/8),
    REAL_CONST(4881.4682617188/8),
    REAL_CONST(4892.6162109375/8),
    REAL_CONST(4903.7705078125/8),
    REAL_CONST(4914.9316406250/8),
    REAL_CONST(4926.0986328125/8),
    REAL_CONST(4937.2719726563/8),
    REAL_CONST(4948.4516601563/8),
    REAL_CONST(4959.6381835938/8),
    REAL_CONST(4970.8305664063/8),
    REAL_CONST(4982.0292968750/8),
    REAL_CONST(4993.2338867188/8),
    REAL_CONST(5004.4453125000/8),
    REAL_CONST(5015.6630859375/8),
    REAL_CONST(5026.8867187500/8),
    REAL_CONST(5038.1171875000/8),
    REAL_CONST(5049.3535156250/8),
    REAL_CONST(5060.5961914063/8),
    REAL_CONST(5071.8447265625/8),
    REAL_CONST(5083.1000976563/8),
    REAL_CONST(5094.3613281250/8),
    REAL_CONST(5105.6289062500/8),
    REAL_CONST(5116.9028320313/8),
    REAL_CONST(5128.1826171875/8),
    REAL_CONST(5139.4692382813/8),
    REAL_CONST(5150.7617187500/8),
    REAL_CONST(5162.0600585938/8),
    REAL_CONST(5173.3647460938/8),
    REAL_CONST(5184.6757812500/8),
    REAL_CONST(5195.9931640625/8),
    REAL_CONST(5207.3164062500/8),
    REAL_CONST(5218.6459960938/8),
    REAL_CONST(5229.9814453125/8),
    REAL_CONST(5241.3232421875/8),
    REAL_CONST(5252.6713867188/8),
    REAL_CONST(5264.0253906250/8),
    REAL_CONST(5275.3852539063/8),
    REAL_CONST(5286.7519531250/8),
    REAL_CONST(5298.1240234375/8),
    REAL_CONST(5309.5029296875/8),
    REAL_CONST(5320.8872070313/8),
    REAL_CONST(5332.2778320313/8),
    REAL_CONST(5343.6748046875/8),
    REAL_CONST(5355.0776367188/8),
    REAL_CONST(5366.4868164063/8),
    REAL_CONST(5377.9018554688/8),
    REAL_CONST(5389.3227539063/8),
    REAL_CONST(5400.7500000000/8),
    REAL_CONST(5412.1831054688/8),
    REAL_CONST(5423.6220703125/8),
    REAL_CONST(5435.0673828125/8),
    REAL_CONST(5446.5190429688/8),
    REAL_CONST(5457.9760742188/8),
    REAL_CONST(5469.4394531250/8),
    REAL_CONST(5480.9086914063/8),
    REAL_CONST(5492.3842773438/8),
    REAL_CONST(5503.8657226563/8),
    REAL_CONST(5515.3530273438/8),
    REAL_CONST(5526.8461914063/8),
    REAL_CONST(5538.3452148438/8),
    REAL_CONST(5549.8505859375/8),
    REAL_CONST(5561.3618164063/8),
    REAL_CONST(5572.8789062500/8),
    REAL_CONST(5584.4023437500/8),
    REAL_CONST(5595.9311523438/8),
    REAL_CONST(5607.4663085938/8),
    REAL_CONST(5619.0073242188/8),
    REAL_CONST(5630.5541992188/8),
    REAL_CONST(5642.1069335938/8),
    REAL_CONST(5653.6655273438/8),
    REAL_CONST(5665.2304687500/8),
    REAL_CONST(5676.8007812500/8),
    REAL_CONST(5688.3774414063/8),
    REAL_CONST(5699.9594726563/8),
    REAL_CONST(5711.5478515625/8),
    REAL_CONST(5723.1420898438/8),
    REAL_CONST(5734.7421875000/8),
    REAL_CONST(5746.3476562500/8),
    REAL_CONST(5757.9594726563/8),
    REAL_CONST(5769.5771484375/8),
    REAL_CONST(5781.2006835938/8),
    REAL_CONST(5792.8300781250/8),
    REAL_CONST(5804.4648437500/8),
    REAL_CONST(5816.1059570313/8),
    REAL_CONST(5827.7524414063/8),
    REAL_CONST(5839.4052734375/8),
    REAL_CONST(5851.0634765625/8),
    REAL_CONST(5862.7280273438/8),
    REAL_CONST(5874.3979492188/8),
    REAL_CONST(5886.0737304688/8),
    REAL_CONST(5897.7553710938/8),
    REAL_CONST(5909.4428710938/8),
    REAL_CONST(5921.1357421875/8),
    REAL_CONST(5932.8349609375/8),
    REAL_CONST(5944.5395507813/8),
    REAL_CONST(5956.2500000000/8),
    REAL_CONST(5967.9663085938/8),
    REAL_CONST(5979.6884765625/8),
    REAL_CONST(5991.4160156250/8),
    REAL_CONST(6003.1494140625/8),
    REAL_CONST(6014.8886718750/8),
    REAL_CONST(6026.6337890625/8),
    REAL_CONST(6038.3842773438/8),
    REAL_CONST(6050.1411132813/8),
    REAL_CONST(6061.9028320313/8),
    REAL_CONST(6073.6708984375/8),
    REAL_CONST(6085.4443359375/8),
    REAL_CONST(6097.2236328125/8),
    REAL_CONST(6109.0083007813/8),
    REAL_CONST(6120.7993164063/8),
    REAL_CONST(6132.5952148438/8),
    REAL_CONST(6144.3974609375/8),
    REAL_CONST(6156.2050781250/8),
    REAL_CONST(6168.0180664063/8),
    REAL_CONST(6179.8374023438/8),
    REAL_CONST(6191.6616210938/8),
    REAL_CONST(6203.4921875000/8),
    REAL_CONST(6215.3281250000/8),
    REAL_CONST(6227.1694335938/8),
    REAL_CONST(6239.0166015625/8),
    REAL_CONST(6250.8696289063/8),
    REAL_CONST(6262.7280273438/8),
    REAL_CONST(6274.5917968750/8),
    REAL_CONST(6286.4614257813/8),
    REAL_CONST(6298.3369140625/8),
    REAL_CONST(6310.2177734375/8),
    REAL_CONST(6322.1040039063/8),
    REAL_CONST(6333.9960937500/8),
    REAL_CONST(6345.8940429688/8),
    REAL_CONST(6357.7968750000/8),
    REAL_CONST(6369.7055664063/8),
    REAL_CONST(6381.6201171875/8),
    REAL_CONST(6393.5400390625/8),
    REAL_CONST(6405.4653320313/8),
    REAL_CONST(6417.3964843750/8),
    REAL_CONST(6429.3330078125/8),
    REAL_CONST(6441.2753906250/8),
    REAL_CONST(6453.2226562500/8),
    REAL_CONST(6465.1757812500/8),
    REAL_CONST(6477.1347656250/8),
    REAL_CONST(6489.0991210938/8),
    REAL_CONST(6501.0688476563/8),
    REAL_CONST(6513.0439453125/8),
    REAL_CONST(6525.0249023438/8),
    REAL_CONST(6537.0107421875/8),
    REAL_CONST(6549.0029296875/8),
    REAL_CONST(6561.0000000000/8),
    REAL_CONST(6573.0029296875/8),
    REAL_CONST(6585.0107421875/8),
    REAL_CONST(6597.0249023438/8),
    REAL_CONST(6609.0439453125/8),
    REAL_CONST(6621.0683593750/8),
    REAL_CONST(6633.0986328125/8),
    REAL_CONST(6645.1342773438/8),
    REAL_CONST(6657.1752929688/8),
    REAL_CONST(6669.2216796875/8),
    REAL_CONST(6681.2734375000/8),
    REAL_CONST(6693.3310546875/8),
    REAL_CONST(6705.3935546875/8),
    REAL_CONST(6717.4619140625/8),
    REAL_CONST(6729.5356445313/8),
    REAL_CONST(6741.6142578125/8),
    REAL_CONST(6753.6987304688/8),
    REAL_CONST(6765.7885742188/8),
    REAL_CONST(6777.8842773438/8),
    REAL_CONST(6789.9848632813/8),
    REAL_CONST(6802.0908203125/8),
    REAL_CONST(6814.2021484375/8),
    REAL_CONST(6826.3188476563/8),
    REAL_CONST(6838.4414062500/8),
    REAL_CONST(6850.5688476563/8),
    REAL_CONST(6862.7016601563/8),
    REAL_CONST(6874.8403320313/8),
    REAL_CONST(6886.9838867188/8),
    REAL_CONST(6899.1328125000/8),
    REAL_CONST(6911.2871093750/8),
    REAL_CONST(6923.4467773438/8),
    REAL_CONST(6935.6118164063/8),
    REAL_CONST(6947.7822265625/8),
    REAL_CONST(6959.9580078125/8),
    REAL_CONST(6972.1391601563/8),
    REAL_CONST(6984.3256835938/8),
    REAL_CONST(6996.5170898438/8),
    REAL_CONST(7008.7143554688/8),
    REAL_CONST(7020.9165039063/8),
    REAL_CONST(7033.1245117188/8),
    REAL_CONST(7045.3374023438/8),
    REAL_CONST(7057.5556640625/8),
    REAL_CONST(7069.7788085938/8),
    REAL_CONST(7082.0078125000/8),
    REAL_CONST(7094.2416992188/8),
    REAL_CONST(7106.4814453125/8),
    REAL_CONST(7118.7260742188/8),
    REAL_CONST(7130.9755859375/8),
    REAL_CONST(7143.2309570313/8),
    REAL_CONST(7155.4912109375/8),
    REAL_CONST(7167.7568359375/8),
    REAL_CONST(7180.0278320313/8),
    REAL_CONST(7192.3041992188/8),
    REAL_CONST(7204.5854492188/8),
    REAL_CONST(7216.8720703125/8),
    REAL_CONST(7229.1640625000/8),
    REAL_CONST(7241.4614257813/8),
    REAL_CONST(7253.7636718750/8),
    REAL_CONST(7266.0712890625/8),
    REAL_CONST(7278.3837890625/8),
    REAL_CONST(7290.7016601563/8),
    REAL_CONST(7303.0249023438/8),
    REAL_CONST(7315.3535156250/8),
    REAL_CONST(7327.6870117188/8),
    REAL_CONST(7340.0258789063/8),
    REAL_CONST(7352.3696289063/8),
    REAL_CONST(7364.7187500000/8),
    REAL_CONST(7377.0732421875/8),
    REAL_CONST(7389.4326171875/8),
    REAL_CONST(7401.7973632813/8),
    REAL_CONST(7414.1669921875/8),
    REAL_CONST(7426.5419921875/8),
    REAL_CONST(7438.9223632813/8),
    REAL_CONST(7451.3076171875/8),
    REAL_CONST(7463.6982421875/8),
    REAL_CONST(7476.0937500000/8),
    REAL_CONST(7488.4941406250/8),
    REAL_CONST(7500.9003906250/8),
    REAL_CONST(7513.3110351563/8),
    REAL_CONST(7525.7275390625/8),
    REAL_CONST(7538.1484375000/8),
    REAL_CONST(7550.5751953125/8),
    REAL_CONST(7563.0063476563/8),
    REAL_CONST(7575.4428710938/8),
    REAL_CONST(7587.8847656250/8),
    REAL_CONST(7600.3315429688/8),
    REAL_CONST(7612.7836914063/8),
    REAL_CONST(7625.2407226563/8),
    REAL_CONST(7637.7026367188/8),
    REAL_CONST(7650.1699218750/8),
    REAL_CONST(7662.6420898438/8),
    REAL_CONST(7675.1191406250/8),
    REAL_CONST(7687.6015625000/8),
    REAL_CONST(7700.0893554688/8),
    REAL_CONST(7712.5815429688/8),
    REAL_CONST(7725.0795898438/8),
    REAL_CONST(7737.5820312500/8),
    REAL_CONST(7750.0898437500/8),
    REAL_CONST(7762.6025390625/8),
    REAL_CONST(7775.1201171875/8),
    REAL_CONST(7787.6430664063/8),
    REAL_CONST(7800.1708984375/8),
    REAL_CONST(7812.7041015625/8),
    REAL_CONST(7825.2416992188/8),
    REAL_CONST(7837.7846679688/8),
    REAL_CONST(7850.3330078125/8),
    REAL_CONST(7862.8857421875/8),
    REAL_CONST(7875.4438476563/8),
    REAL_CONST(7888.0068359375/8),
    REAL_CONST(7900.5747070313/8),
    REAL_CONST(7913.1479492188/8),
    REAL_CONST(7925.7260742188/8),
    REAL_CONST(7938.3090820313/8),
    REAL_CONST(7950.8969726563/8),
    REAL_CONST(7963.4897460938/8),
    REAL_CONST(7976.0878906250/8),
    REAL_CONST(7988.6909179688/8),
    REAL_CONST(8001.2988281250/8),
    REAL_CONST(8013.9116210938/8),
    REAL_CONST(8026.5292968750/8),
    REAL_CONST(8039.1523437500/8),
    REAL_CONST(8051.7797851563/8),
    REAL_CONST(8064.4125976563/8),
    REAL_CONST(8077.0502929688/8),
    REAL_CONST(8089.6928710938/8),
    REAL_CONST(8102.3403320313/8),
    REAL_CONST(8114.9931640625/8),
    REAL_CONST(8127.6503906250/8),
    REAL_CONST(8140.3129882813/8),
    REAL_CONST(8152.9799804688/8),
    REAL_CONST(8165.6523437500/8),
    REAL_CONST(8178.3295898438/8),
    REAL_CONST(8191.0117187500/8),
    REAL_CONST(8203.6982421875/8),
    REAL_CONST(8216.3906250000/8),
    REAL_CONST(8229.0869140625/8),
    REAL_CONST(8241.7890625000/8),
    REAL_CONST(8254.4951171875/8),
    REAL_CONST(8267.2070312500/8),
    REAL_CONST(8279.9228515625/8),
    REAL_CONST(8292.6445312500/8),
    REAL_CONST(8305.3701171875/8),
    REAL_CONST(8318.1015625000/8),
    REAL_CONST(8330.8369140625/8),
    REAL_CONST(8343.5781250000/8),
    REAL_CONST(8356.3232421875/8),
    REAL_CONST(8369.0742187500/8),
    REAL_CONST(8381.8291015625/8),
    REAL_CONST(8394.5898437500/8),
    REAL_CONST(8407.3544921875/8),
    REAL_CONST(8420.1240234375/8),
    REAL_CONST(8432.8994140625/8),
    REAL_CONST(8445.6787109375/8),
    REAL_CONST(8458.4628906250/8),
    REAL_CONST(8471.2519531250/8),
    REAL_CONST(8484.0458984375/8),
    REAL_CONST(8496.8447265625/8),
    REAL_CONST(8509.6484375000/8),
    REAL_CONST(8522.4570312500/8),
    REAL_CONST(8535.2705078125/8),
    REAL_CONST(8548.0888671875/8),
    REAL_CONST(8560.9111328125/8),
    REAL_CONST(8573.7392578125/8),
    REAL_CONST(8586.5722656250/8),
    REAL_CONST(8599.4091796875/8),
    REAL_CONST(8612.2509765625/8),
    REAL_CONST(8625.0986328125/8),
    REAL_CONST(8637.9501953125/8),
    REAL_CONST(8650.8066406250/8),
    REAL_CONST(8663.6679687500/8),
    REAL_CONST(8676.5332031250/8),
    REAL_CONST(8689.4042968750/8),
    REAL_CONST(8702.2802734375/8),
    REAL_CONST(8715.1601562500/8),
    REAL_CONST(8728.0458984375/8),
    REAL_CONST(8740.9355468750/8),
    REAL_CONST(8753.8300781250/8),
    REAL_CONST(8766.7294921875/8),
    REAL_CONST(8779.6337890625/8),
    REAL_CONST(8792.5419921875/8),
    REAL_CONST(8805.4560546875/8),
    REAL_CONST(8818.3740234375/8),
    REAL_CONST(8831.2968750000/8),
    REAL_CONST(8844.2246093750/8),
    REAL_CONST(8857.1572265625/8),
    REAL_CONST(8870.0947265625/8),
    REAL_CONST(8883.0371093750/8),
    REAL_CONST(8895.9833984375/8),
    REAL_CONST(8908.9345703125/8),
    REAL_CONST(8921.8906250000/8),
    REAL_CONST(8934.8515625000/8),
    REAL_CONST(8947.8173828125/8),
    REAL_CONST(8960.7871093750/8),
    REAL_CONST(8973.7626953125/8),
    REAL_CONST(8986.7421875000/8),
    REAL_CONST(8999.7265625000/8),
    REAL_CONST(9012.7148437500/8),
    REAL_CONST(9025.7089843750/8),
    REAL_CONST(9038.7070312500/8),
    REAL_CONST(9051.7099609375/8),
    REAL_CONST(9064.7177734375/8),
    REAL_CONST(9077.7304687500/8),
    REAL_CONST(9090.7470703125/8),
    REAL_CONST(9103.7685546875/8),
    REAL_CONST(9116.7949218750/8),
    REAL_CONST(9129.8261718750/8),
    REAL_CONST(9142.8613281250/8),
    REAL_CONST(9155.9023437500/8),
    REAL_CONST(9168.9472656250/8),
    REAL_CONST(9181.9960937500/8),
    REAL_CONST(9195.0507812500/8),
    REAL_CONST(9208.1093750000/8),
    REAL_CONST(9221.1728515625/8),
    REAL_CONST(9234.2412109375/8),
    REAL_CONST(9247.3134765625/8),
    REAL_CONST(9260.3906250000/8),
    REAL_CONST(9273.4726562500/8),
    REAL_CONST(9286.5595703125/8),
    REAL_CONST(9299.6503906250/8),
    REAL_CONST(9312.7460937500/8),
    REAL_CONST(9325.8466796875/8),
    REAL_CONST(9338.9521484375/8),
    REAL_CONST(9352.0615234375/8),
    REAL_CONST(9365.1757812500/8),
    REAL_CONST(9378.2949218750/8),
    REAL_CONST(9391.4179687500/8),
    REAL_CONST(9404.5458984375/8),
    REAL_CONST(9417.6787109375/8),
    REAL_CONST(9430.8154296875/8),
    REAL_CONST(9443.9570312500/8),
    REAL_CONST(9457.1035156250/8),
    REAL_CONST(9470.2539062500/8),
    REAL_CONST(9483.4101562500/8),
    REAL_CONST(9496.5693359375/8),
    REAL_CONST(9509.7343750000/8),
    REAL_CONST(9522.9033203125/8),
    REAL_CONST(9536.0771484375/8),
    REAL_CONST(9549.2548828125/8),
    REAL_CONST(9562.4384765625/8),
    REAL_CONST(9575.6250000000/8),
    REAL_CONST(9588.8173828125/8),
    REAL_CONST(9602.0136718750/8),
    REAL_CONST(9615.2148437500/8),
    REAL_CONST(9628.4199218750/8),
    REAL_CONST(9641.6298828125/8),
    REAL_CONST(9654.8447265625/8),
    REAL_CONST(9668.0634765625/8),
    REAL_CONST(9681.2871093750/8),
    REAL_CONST(9694.5146484375/8),
    REAL_CONST(9707.7470703125/8),
    REAL_CONST(9720.9843750000/8),
    REAL_CONST(9734.2265625000/8),
    REAL_CONST(9747.4726562500/8),
    REAL_CONST(9760.7226562500/8),
    REAL_CONST(9773.9775390625/8),
    REAL_CONST(9787.2373046875/8),
    REAL_CONST(9800.5019531250/8),
    REAL_CONST(9813.7705078125/8),
    REAL_CONST(9827.0429687500/8),
    REAL_CONST(9840.3212890625/8),
    REAL_CONST(9853.6025390625/8),
    REAL_CONST(9866.8896484375/8),
    REAL_CONST(9880.1806640625/8),
    REAL_CONST(9893.4755859375/8),
    REAL_CONST(9906.7753906250/8),
    REAL_CONST(9920.0800781250/8),
    REAL_CONST(9933.3886718750/8),
    REAL_CONST(9946.7021484375/8),
    REAL_CONST(9960.0195312500/8),
    REAL_CONST(9973.3417968750/8),
    REAL_CONST(9986.6689453125/8),
    REAL_CONST(10000.0000000000/8),
    REAL_CONST(10013.3359375000/8),
    REAL_CONST(10026.6757812500/8),
    REAL_CONST(10040.0195312500/8),
    REAL_CONST(10053.3691406250/8),
    REAL_CONST(10066.7216796875/8),
    REAL_CONST(10080.0800781250/8),
    REAL_CONST(10093.4423828125/8),
    REAL_CONST(10106.8085937500/8),
    REAL_CONST(10120.1796875000/8),
    REAL_CONST(10133.5546875000/8),
    REAL_CONST(10146.9345703125/8),
    REAL_CONST(10160.3193359375/8),
    REAL_CONST(10173.7080078125/8),
    REAL_CONST(10187.1005859375/8),
    REAL_CONST(10200.4980468750/8),
    REAL_CONST(10213.9003906250/8),
    REAL_CONST(10227.3066406250/8),
    REAL_CONST(10240.7167968750/8),
    REAL_CONST(10254.1318359375/8),
    REAL_CONST(10267.5517578125/8),
    REAL_CONST(10280.9755859375/8),
    REAL_CONST(10294.4033203125/8),
    REAL_CONST(10307.8359375000/8),
    REAL_CONST(10321.2734375000/8),
    REAL_CONST(10334.7148437500/8)
};

#endif

#ifdef __cplusplus
}
#endif
#endif
