/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.ActionEditor;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.CheckboxEditEvent;
import vlcskineditor.history.ItemAddEvent;

public class Checkbox
extends Item
implements ActionListener {
    public final String DOWN1_DEFAULT = "none";
    public final String DOWN2_DEFAULT = "none";
    public final String OVER1_DEFAULT = "none";
    public final String OVER2_DEFAULT = "none";
    public final String ACTION1_DEFAULT = "none";
    public final String ACTION2_DEFAULT = "none";
    public final String TOOLTIPTEXT1_DEFAULT = "";
    public final String TOOLTIPTEXT2_DEFAULT = "";
    public String up1;
    public String up2;
    public String down1 = "none";
    public String down2 = "none";
    public String over1 = "none";
    public String over2 = "none";
    public String state;
    public String action1 = "none";
    public String action2 = "none";
    public String tooltiptext1 = "";
    public String tooltiptext2 = "";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField up1_tf;
    JTextField down1_tf;
    JTextField over1_tf;
    JTextField action1_tf;
    JTextField tooltiptext1_tf;
    JTextField up2_tf;
    JTextField down2_tf;
    JTextField over2_tf;
    JTextField action2_tf;
    JTextField tooltiptext2_tf;
    JTextField state_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JButton visible_btn;
    JButton action1_btn;
    JButton action2_btn;
    JButton state_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    ActionEditor action1_ae;
    ActionEditor action2_ae;

    public Checkbox(String string, Skin skin) {
        this.type = "Checkbox";
        this.s = skin;
        this.up1 = XML.getValue(string, "up1");
        this.up2 = XML.getValue(string, "up2");
        this.state = XML.getValue(string, "state");
        if (string.indexOf(" over1=\"") != -1) {
            this.over1 = XML.getValue(string, "over1");
        }
        if (string.indexOf(" over2=\"") != -1) {
            this.over2 = XML.getValue(string, "over2");
        }
        if (string.indexOf(" down1=\"") != -1) {
            this.down1 = XML.getValue(string, "down1");
        }
        if (string.indexOf(" down2=\"") != -1) {
            this.down2 = XML.getValue(string, "down2");
        }
        if (string.indexOf(" up1=\"") != -1) {
            this.up1 = XML.getValue(string, "up1");
        }
        if (string.indexOf(" up2=\"") != -1) {
            this.up2 = XML.getValue(string, "up2");
        }
        if (string.indexOf(" action1=\"") != -1) {
            this.action1 = XML.getValue(string, "action1");
        }
        if (string.indexOf(" action2=\"") != -1) {
            this.action2 = XML.getValue(string, "action2");
        }
        if (string.indexOf(" tooltiptext1=\"") != -1) {
            this.tooltiptext1 = XML.getValue(string, "tooltiptext1");
        }
        if (string.indexOf(" tooltiptext2=\"") != -1) {
            this.tooltiptext2 = XML.getValue(string, "tooltiptext2");
        }
        if (string.indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf(" id=\"") != -1 ? XML.getValue(string, "id") : "Unnamed checkbox #" + this.s.getNewId();
        if (string.indexOf(" lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        if (string.indexOf(" rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(string, "rightbottom");
        }
        if (string.indexOf(" xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(string, "xkeepratio");
        }
        if (string.indexOf(" ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(string, "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        this.created = true;
    }

    public Checkbox(Skin skin) {
        this.type = "Checkbox";
        this.s = skin;
        this.up1 = "none";
        this.up2 = "none";
        this.state = "false";
        this.id = "Unnamed checkbox #" + this.s.getNewId();
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up1 = this.up1_tf.getText();
            this.over1 = this.over1_tf.getText();
            this.down1 = this.down1_tf.getText();
            this.action1 = this.action1_tf.getText();
            this.tooltiptext1 = this.tooltiptext1_tf.getText();
            this.up2 = this.up2_tf.getText();
            this.over2 = this.over2_tf.getText();
            this.down2 = this.down2_tf.getText();
            this.action2 = this.action2_tf.getText();
            this.tooltiptext2 = this.tooltiptext2_tf.getText();
            this.state = this.state_tf.getText();
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
        } else {
            CheckboxEditEvent checkboxEditEvent = new CheckboxEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up1 = this.up1_tf.getText();
            this.over1 = this.over1_tf.getText();
            this.down1 = this.down1_tf.getText();
            this.action1 = this.action1_tf.getText();
            this.tooltiptext1 = this.tooltiptext1_tf.getText();
            this.up2 = this.up2_tf.getText();
            this.over2 = this.over2_tf.getText();
            this.down2 = this.down2_tf.getText();
            this.action2 = this.action2_tf.getText();
            this.tooltiptext2 = this.tooltiptext2_tf.getText();
            this.state = this.state_tf.getText();
            checkboxEditEvent.setNew();
            this.s.m.hist.addEvent(checkboxEditEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Checkbox settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            this.frame.setDefaultCloseOperation(0);
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", this.s.m.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Normal image*:");
            this.up1_tf = new JTextField();
            JLabel jLabel11 = new JLabel("Mouse-over image:");
            this.over1_tf = new JTextField();
            JLabel jLabel12 = new JLabel("Mouse-click image:");
            this.down1_tf = new JTextField();
            JLabel jLabel13 = new JLabel("Action:");
            this.action1_tf = new JTextField();
            this.action1_btn = new JButton("", this.s.m.editor_icon);
            this.action1_btn.addActionListener(this);
            JLabel jLabel14 = new JLabel("Tooltiptext:");
            this.tooltiptext1_tf = new JTextField();
            JLabel jLabel15 = new JLabel("Normal image*:");
            this.up2_tf = new JTextField();
            JLabel jLabel16 = new JLabel("Mouse-over image:");
            this.over2_tf = new JTextField();
            JLabel jLabel17 = new JLabel("Mouse-click image:");
            this.down2_tf = new JTextField();
            JLabel jLabel18 = new JLabel("Action:");
            this.action2_tf = new JTextField();
            this.action2_btn = new JButton("", this.s.m.editor_icon);
            this.action2_btn.addActionListener(this);
            JLabel jLabel19 = new JLabel("Tooltiptext:");
            this.tooltiptext2_tf = new JTextField();
            JLabel jLabel20 = new JLabel("Condition:");
            this.state_tf = new JTextField();
            this.state_tf.setToolTipText("Boolean expression specifying the state of the checkbox: if the expression resolves to 'false', the first state will be used, and if it resolves to 'true' the second state will be used. Example for a checkbox showing/hiding a window whose id is \"playlist_window\": state=\"playlist_window.isVisible\" (or state=\"not playlist_window.isVisible\", depending on the states you chose).");
            this.state_btn = new JButton("", this.s.m.help_icon);
            this.state_btn.addActionListener(this);
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(240, 45, 75, 24);
            this.y_tf.setBounds(325, 45, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 75, 75, 24);
            this.lefttop_cb.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(240, 75, 75, 24);
            this.rightbottom_cb.setBounds(325, 75, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 105, 75, 24);
            this.xkeepratio_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(240, 105, 75, 24);
            this.ykeepratio_cb.setBounds(325, 105, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jLabel8.setBounds(5, 135, 75, 24);
            this.visible_tf.setBounds(85, 135, 120, 24);
            this.visible_btn.setBounds(210, 225, 24, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(240, 135, 75, 24);
            this.help_tf.setBounds(325, 135, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(495, 165));
            jPanel.setPreferredSize(new Dimension(495, 165));
            jPanel.setMaximumSize(new Dimension(495, 165));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel20);
            jPanel2.add(this.state_tf);
            jPanel2.add(this.state_btn);
            jLabel20.setBounds(5, 15, 75, 24);
            this.state_tf.setBounds(85, 15, 120, 24);
            this.state_btn.setBounds(210, 15, 24, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Checkbox state"));
            jPanel2.setMinimumSize(new Dimension(495, 45));
            jPanel2.setPreferredSize(new Dimension(495, 45));
            jPanel2.setMaximumSize(new Dimension(495, 45));
            this.frame.add(jPanel2);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.add(jLabel10);
            jPanel3.add(this.up1_tf);
            jLabel10.setBounds(5, 15, 75, 24);
            this.up1_tf.setBounds(85, 15, 150, 24);
            jPanel3.add(jLabel11);
            jPanel3.add(this.over1_tf);
            jLabel11.setBounds(5, 45, 75, 24);
            this.over1_tf.setBounds(85, 45, 150, 24);
            jPanel3.add(jLabel12);
            jPanel3.add(this.down1_tf);
            jLabel12.setBounds(5, 75, 75, 24);
            this.down1_tf.setBounds(85, 75, 150, 24);
            jPanel3.add(jLabel13);
            jPanel3.add(this.action1_tf);
            jPanel3.add(this.action1_btn);
            jLabel13.setBounds(5, 105, 75, 24);
            this.action1_tf.setBounds(85, 105, 120, 24);
            this.action1_btn.setBounds(210, 105, 24, 24);
            jPanel3.add(jLabel14);
            jPanel3.add(this.tooltiptext1_tf);
            jLabel14.setBounds(5, 135, 75, 24);
            this.tooltiptext1_tf.setBounds(85, 135, 150, 24);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "State One (Condition is not fulfilled:"));
            jPanel3.setMinimumSize(new Dimension(240, 165));
            jPanel3.setPreferredSize(new Dimension(240, 165));
            jPanel3.setMaximumSize(new Dimension(240, 165));
            this.frame.add(jPanel3);
            JPanel jPanel4 = new JPanel(null);
            jPanel4.add(jLabel15);
            jPanel4.add(this.up2_tf);
            jLabel15.setBounds(5, 15, 75, 24);
            this.up2_tf.setBounds(85, 15, 150, 24);
            jPanel4.add(jLabel16);
            jPanel4.add(this.over2_tf);
            jLabel16.setBounds(5, 45, 75, 24);
            this.over2_tf.setBounds(85, 45, 150, 24);
            jPanel4.add(jLabel17);
            jPanel4.add(this.down2_tf);
            jLabel17.setBounds(5, 75, 75, 24);
            this.down2_tf.setBounds(85, 75, 150, 24);
            jPanel4.add(jLabel18);
            jPanel4.add(this.action2_tf);
            jPanel4.add(this.action2_btn);
            jLabel18.setBounds(5, 105, 75, 24);
            this.action2_tf.setBounds(85, 105, 120, 24);
            this.action2_btn.setBounds(210, 105, 24, 24);
            jPanel4.add(jLabel19);
            jPanel4.add(this.tooltiptext2_tf);
            jLabel19.setBounds(5, 135, 75, 24);
            this.tooltiptext2_tf.setBounds(85, 135, 150, 24);
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "State Two (Condition is fulfilled):"));
            jPanel4.setMinimumSize(new Dimension(240, 165));
            jPanel4.setPreferredSize(new Dimension(240, 165));
            jPanel4.setMaximumSize(new Dimension(240, 165));
            this.frame.add(jPanel4);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(505, 450));
            this.frame.setPreferredSize(new Dimension(505, 450));
            this.frame.setMaximumSize(new Dimension(505, 450));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.state_tf.setText(this.state);
        this.up1_tf.setText(this.up1);
        this.over1_tf.setText(this.over1);
        this.down1_tf.setText(this.down1);
        this.action1_tf.setText(this.action1);
        this.tooltiptext1_tf.setText(this.tooltiptext1);
        this.up2_tf.setText(this.up2);
        this.over2_tf.setText(this.over2);
        this.down2_tf.setText(this.down2);
        this.action2_tf.setText(this.action2);
        this.tooltiptext2_tf.setText(this.tooltiptext2);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (this.state_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please provide the state condition!", "State not valid", 1);
                return;
            }
            if (this.s.getResource(this.up1_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.up1_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.over1_tf.getText().equals("none") && this.s.getResource(this.over1_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.over1_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.down1_tf.getText().equals("none") && this.s.getResource(this.down1_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.down1_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (this.s.getResource(this.up2_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.up2_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.over2_tf.getText().equals("none") && this.s.getResource(this.over2_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.over2_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.down2_tf.getText().equals("none") && this.s.getResource(this.down2_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.down2_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-checkbox.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-checkbox.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.state_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/boolexpr.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/boolexpr.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.action1_btn)) {
            if (this.action1_ae == null) {
                this.action1_ae = new ActionEditor(this);
            }
            this.action1_ae.editAction(this.action1_tf.getText());
        } else if (actionEvent.getSource().equals(this.action2_btn)) {
            if (this.action2_ae == null) {
                this.action2_ae = new ActionEditor(this);
            }
            this.action2_ae.editAction(this.action2_tf.getText());
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/boolexpr.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/boolexpr.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void actionWasEdited(ActionEditor actionEditor) {
        if (actionEditor == this.action1_ae) {
            this.action1_tf.setText(this.action1_ae.getCode());
        } else if (actionEditor == this.action2_ae) {
            this.action2_tf.setText(this.action2_ae.getCode());
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Checkbox";
        string2 = string2 + " state=\"" + this.state + "\" up1=\"" + this.up1 + "\" up2=\"" + this.up2 + "\"";
        if (!this.down1.equals("Unnamed")) {
            string2 = string2 + " down1=\"" + this.down1 + "\"";
        }
        if (!this.down2.equals("Unnamed")) {
            string2 = string2 + " down2=\"" + this.down2 + "\"";
        }
        if (!this.over1.equals("Unnamed")) {
            string2 = string2 + " over1=\"" + this.over1 + "\"";
        }
        if (!this.over2.equals("Unnamed")) {
            string2 = string2 + " over2=\"" + this.over2 + "\"";
        }
        if (!this.action1.equals("Unnamed")) {
            string2 = string2 + " action1=\"" + this.action1 + "\"";
        }
        if (!this.action2.equals("Unnamed")) {
            string2 = string2 + " action2=\"" + this.action2 + "\"";
        }
        if (!this.tooltiptext1.equals("Unnamed")) {
            string2 = string2 + " tooltiptext1=\"" + this.tooltiptext1 + "\"";
        }
        if (!this.tooltiptext2.equals("Unnamed")) {
            string2 = string2 + " tooltiptext2=\"" + this.tooltiptext2 + "\"";
        }
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        BufferedImage bufferedImage = null;
        bufferedImage = this.s.gvars.parseBoolean(this.state) ? (!this.hovered || this.over2.equals("none") && !this.clicked || this.clicked && this.down2.equals("none") ? this.s.getBitmapImage(this.up2) : (!this.clicked || this.down2.equals("none") ? this.s.getBitmapImage(this.over2) : this.s.getBitmapImage(this.down2))) : (!this.hovered || this.over1.equals("none") && !this.clicked || this.clicked && this.down1.equals("none") ? this.s.getBitmapImage(this.up1) : (!this.clicked || this.down1.equals("none") ? this.s.getBitmapImage(this.over2) : this.s.getBitmapImage(this.down2)));
        if (this.s.gvars.parseBoolean(this.visible)) {
            graphics2D.drawImage(bufferedImage, (this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3 - 1, bufferedImage.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        BufferedImage bufferedImage = this.s.getBitmapImage(this.up1);
        return n >= this.x + this.offsetx && n <= this.x + bufferedImage.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + bufferedImage.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Checkbox: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.up1.equals(string) || this.up2.equals(string) || this.over1.equals(string) || this.over2.equals(string) || this.down1.equals(string) || this.down2.equals(string);
    }
}

