/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file is part of libmatroska.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: KaxChapters.h,v 1.1 2003/07/16 15:39:25 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/
#ifndef LIBMATROSKA_CHAPTERS_H
#define LIBMATROSKA_CHAPTERS_H

#include "matroska/KaxTypes.h"
#include "ebml/EbmlMaster.h"
#include "ebml/EbmlUInteger.h"
#include "ebml/EbmlUnicodeString.h"
#include "ebml/EbmlString.h"

using namespace LIBEBML_NAMESPACE;

START_LIBMATROSKA_NAMESPACE

class KaxChapters : public EbmlMaster {
	public:
		KaxChapters();
		static EbmlElement & Create() {return *(new KaxChapters);}
		const EbmlCallbacks & Generic() const {return ClassInfos;}
		static const EbmlCallbacks ClassInfos;
		operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxEditionEntry : public EbmlMaster {
public:
    KaxEditionEntry();
    static EbmlElement & Create() {return *(new KaxEditionEntry);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterAtom : public EbmlMaster {
public:
    KaxChapterAtom();
    static EbmlElement & Create() {return *(new KaxChapterAtom);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterUID : public EbmlUInteger {
public:
    KaxChapterUID() {}
    static EbmlElement & Create() {return *(new KaxChapterUID);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterTimeStart : public EbmlUInteger {
public:
    KaxChapterTimeStart() {}
    static EbmlElement & Create() {return *(new KaxChapterTimeStart);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterTimeEnd : public EbmlUInteger {
public:
    KaxChapterTimeEnd() {}
    static EbmlElement & Create() {return *(new KaxChapterTimeEnd);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterTrack : public EbmlMaster {
public:
    KaxChapterTrack();
    static EbmlElement & Create() {return *(new KaxChapterTrack);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterTrackNumber : public EbmlUInteger {
public:
    KaxChapterTrackNumber() {}
    static EbmlElement & Create() {return *(new KaxChapterTrackNumber);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterDisplay : public EbmlMaster {
public:
    KaxChapterDisplay();
    static EbmlElement & Create() {return *(new KaxChapterDisplay);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterString : public EbmlUnicodeString {
public:
    KaxChapterString() {}
    static EbmlElement & Create() {return *(new KaxChapterString);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterLanguage : public EbmlString {
public:
    KaxChapterLanguage() :EbmlString("eng") {}
    static EbmlElement & Create() {return *(new KaxChapterLanguage);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

class KaxChapterCountry : public EbmlString {
public:
    KaxChapterCountry() :EbmlString() {}
    static EbmlElement & Create() {return *(new KaxChapterCountry);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
};

END_LIBMATROSKA_NAMESPACE

#endif // LIBMATROSKA_CHAPTERS_H
