/*****************************************************************************
 * logger.h: VideoLAN Channel Server logging facility
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: logger.h,v 1.6 2002/10/28 17:38:30 marcari Exp $
 *
 * Authors: Marc Ariberti <marcari@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/


class C_Logger
{
public:
    typedef enum { DEBUG, INFO, WARNING, ERROR, ALERT, END } log_command;

    virtual ~C_Logger( void ) = 0;
    virtual C_Logger &operator<<(const char * msg) = 0;
    virtual C_Logger &operator<<(int value) = 0;
    virtual C_Logger &operator<<(log_command value) = 0;
};


class C_ChainedLogger : public C_Logger
{
public:
    C_ChainedLogger();
    virtual ~C_ChainedLogger( void );
    virtual C_Logger &operator<<(const char * msg);
    virtual C_Logger &operator<<(int value);
    virtual C_Logger &operator<<(log_command value);

    void Add(C_Logger * logger);
    void Remove(C_Logger * logger);
protected:
    std::list<C_Logger *> logger_list;
};

class C_SysLogger : public C_Logger
{
public:
    C_SysLogger(const char * syslog_name, int facility);
    virtual ~C_SysLogger( void );
    virtual C_Logger &operator<<(const char * msg);
    virtual C_Logger &operator<<(int value);
    virtual C_Logger &operator<<(log_command value);

protected:
    std::string buffer;
    int level;
};

class C_FileLogger : public C_Logger
{
public:
    typedef enum { NO_COLOR, LINUX } logging_color;
    
//    C_FileLogger(int fd, logging_color color = NO_COLOR);
    C_FileLogger(const char * filename, logging_color color = NO_COLOR);
    virtual ~C_FileLogger( void );

    virtual C_Logger &operator<<(const char * msg);
    virtual C_Logger &operator<<(int value);
    virtual C_Logger &operator<<(log_command value);

protected:
    std::ofstream log_file;
    logging_color m_color;
};

class C_StdLogger : public C_FileLogger
{
public:
    C_StdLogger( logging_color color = NO_COLOR );
    virtual ~C_StdLogger( void );
};

