/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;

import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;

/**
 * A streaming server.
 * 
 * @author SylV
 * @version 1.0
 * 
 */
public class VlServerFake extends VlServer {

    public VlServerFake(String name, InetAddress ip) {
        super(name, ip);
    }

    /**
     * Updates RRD data.
     */
    public void updateSnmpData() {
        String rrdFile = createRrdFileIfNecessary();

        Random r = new Random();

        currentCpuLoad = r.nextFloat() * 1.5;
        currentTrafficIn = r.nextInt(10000000);
        currentTrafficOut = r.nextInt(10000000);
        currentVlcCpu = r.nextFloat();
        currentVlcMem = r.nextFloat();

        try {
            RrdDbPool rrdPool = RrdDbPool.getInstance();
            RrdDb rrdDb = rrdPool.requestRrdDb(rrdFile);
            Sample sample = rrdDb.createSample();
            // sample.setAndUpdate(Util.getTime() + ":" + cpuLoadString)
            sample.setValue("cpu_load", currentCpuLoad);
            sample.setValue("traffic_in", currentTrafficIn);
            sample.setValue("traffic_out", currentTrafficOut);
            sample.setValue("vlc_cpu", currentVlcCpu);
            sample.setValue("vlc_mem", currentVlcMem);
            sample.update();
            rrdPool.release(rrdDb);
        } catch (RrdException e) {
            logger.error(
                    "Error while updating RRD data of " + getName(), e);

        } catch (IOException e) {
            logger.error(
                    "Error while updating RRD data of " + getName(), e);

        }
    }

    /**
     * Verifies the accessibility of the server.
     * Updates the server state according to the result of the test.
     * 
     * @return the server accessibility: true if accessible, false otherwise
     */
    public boolean checkVLC() {
        /*if (new Random().nextBoolean()) {
            setUp(true);
        } else {
            setUp(false);
        }
        return isUp;*/
        return true;
    }

}
