/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.videolan.vlma.common.Configuration;
import org.videolan.vlma.common.IVlOrderGiver;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.exceptions.AdapterAlreadyExistsException;
import org.videolan.vlma.common.exceptions.AdapterDoesNotExistException;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.exceptions.MediaDoesNotExistException;
import org.videolan.vlma.common.exceptions.SatelliteAlreadyExistsException;
import org.videolan.vlma.common.exceptions.SatelliteDoesNotExistException;
import org.videolan.vlma.common.exceptions.ServerAlreadyExistsException;
import org.videolan.vlma.common.exceptions.ServerDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlSatellite;
import org.videolan.vlma.common.orders.VlOrder;
import org.videolan.vlma.common.programs.IVlProgram;
import org.videolan.vlma.common.programs.VlProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IVlData {
    public Configuration getConfiguration();

    public List<VlSatellite> getSatellites();

    public VlSatellite getSatellite(int var1) throws SatelliteDoesNotExistException;

    public void clearSatelliteCoverages(int var1) throws SatelliteDoesNotExistException;

    public void addSatelliteCoverage(int var1, String var2) throws SatelliteDoesNotExistException;

    public int addSatellite(String var1) throws SatelliteAlreadyExistsException;

    public List<String> getSatelliteCoverages(int var1) throws SatelliteDoesNotExistException;

    public void removeSatellite(int var1) throws SatelliteDoesNotExistException;

    public List<VlServer> getServers();

    public VlServer getServer(int var1) throws ServerDoesNotExistException;

    public VlServer getServer(String var1) throws ServerDoesNotExistException;

    public int addServer(String var1) throws ServerAlreadyExistsException;

    public void setServerIp(int var1, InetAddress var2) throws ServerDoesNotExistException;

    public void removeServer(int var1) throws ServerDoesNotExistException;

    public Map<String, IVlAdapter> getAdapters(int var1) throws ServerDoesNotExistException;

    public IVlAdapter getAdapter(int var1, String var2) throws ServerDoesNotExistException, AdapterDoesNotExistException;

    public void setAdapterName(int var1, String var2, String var3) throws AdapterDoesNotExistException, AdapterAlreadyExistsException;

    public void setAdapterParameter(int var1, String var2, String var3, String var4) throws AdapterDoesNotExistException, AdapterParameterDoesNotExistException;

    public void addAdapter(int var1, String var2, String var3) throws AdapterAlreadyExistsException, IllegalAccessException, InstantiationException, ClassNotFoundException;

    public void removeAdapter(int var1, String var2) throws AdapterDoesNotExistException;

    public List<IVlMedia> getMedias();

    public IVlMedia getMedia(int var1);

    public int addMedia(IVlMedia var1);

    public void sortMedias();

    public void setFilesChannelFilesList(int var1, String var2);

    public void setFilesChannelServer(int var1, String var2);

    public void updateMediaProgram(int var1, IVlProgram var2) throws MediaDoesNotExistException;

    public VlProgram addMediaProgram(int var1) throws MediaDoesNotExistException;

    public void removeMedia(int var1) throws MediaDoesNotExistException;

    public void updateSatChannels(URL var1) throws IOException;

    public HashMap<Integer, List<VlOrder>> getOrders();

    public void giveOrders();

    public IVlOrderGiver getOrderGiver();

    public void saveToDisk() throws FileNotFoundException, IOException;

    public void loadFromDisk() throws FileNotFoundException, IOException;

    public void startOrderMonitoring();

    public void startCheckAllVLCs();
}

