/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.media;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.Data;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.SatChannel;
import org.videolan.vlma.model.StreamChannel;

public class MediaProgramAddController extends SimpleFormController {

    private Data data;

    private String successViewDTT;

    private String successViewSat;

    private String successViewFile;

    private String successViewStream;

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public String getSuccessViewSat() {
        return successViewSat;
    }

    public String getSuccessViewDTT() {
        return successViewDTT;
    }

    public void setSuccessViewDTT(String successViewDTT) {
        this.successViewDTT = successViewDTT;
    }

    public void setSuccessViewSat(String successViewSat) {
        this.successViewSat = successViewSat;
    }

    public String getSuccessViewFile() {
        return successViewFile;
    }

    public void setSuccessViewFile(String successViewFile) {
        this.successViewFile = successViewFile;
    }

    public String getSuccessViewStream() {
        return successViewStream;
    }

    public void setSuccessViewStream(String successViewStream) {
        this.successViewStream = successViewStream;
    }

    @Override
    public ModelAndView onSubmit(Object command) throws ServletException,
            MalformedURLException, IOException {
        MediaProgramAdd mediasProgramAdd = (MediaProgramAdd) command;

        int mediaId = mediasProgramAdd.getMediaId();
        Media media = data.getMedia(mediaId);

        Program program = data.newProgram();
        program.setPriority(Integer.parseInt(mediasProgramAdd.getPriority()));
        program.setSapName(mediasProgramAdd.getSap());
        program.getStreamingStrategy().setProtocol(mediasProgramAdd.getProtocol());
        program.getStreamingStrategy().setEncapsulation(mediasProgramAdd.getMux());
        program.getStreamingStrategy().setAnnouncements(mediasProgramAdd.getAnnouncements());
        media.setProgram(program);
        data.update(media);

        // Determine the success view with the media class
        String successView = null;
        if (media.getClass() == FilesChannel.class) {
            successView = getSuccessViewFile();
        }
        else if (media.getClass() == StreamChannel.class) {
            successView = getSuccessViewStream();
        }
        else if (media.getClass() == SatChannel.class) {
            successView = getSuccessViewSat();
        } else {
            successView = getSuccessViewDTT();
        }

        return new ModelAndView(new RedirectView(successView));
    }

    @Override
    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        MediaProgramAdd mediasProgramAdd = new MediaProgramAdd();
        int mediaId = Integer.parseInt(request.getParameter("media"));
        Media media = data.getMedia(mediaId);
        Program program;
        if (media.getProgram() == null) {
            program = data.newProgram();
        } else {
            program = media.getProgram();
        }
        mediasProgramAdd.setPriority("10");
        if (media.getClass() == SatChannel.class){
            String country = ((SatChannel)media).getCountry().toString();
            if (country.length() > 0)
                mediasProgramAdd.setSap("[" + country + "] " + media.getName());
            else
                mediasProgramAdd.setSap(media.getName());
        }
        mediasProgramAdd.setSap(media.getName());
        mediasProgramAdd.setMediaId(mediaId);
        mediasProgramAdd.setProtocol(program.getStreamingStrategy().getProtocol());
        mediasProgramAdd.setMux(program.getStreamingStrategy().getEncapsulation());
        mediasProgramAdd.setAnnouncements(program.getStreamingStrategy().getAnnouncements());
        return mediasProgramAdd;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0,
            HttpServletResponse arg1, BindException arg2, Map arg3)
            throws Exception {
        int mediaId = Integer.parseInt(arg0.getParameter("media"));
        Map<String, Object> m = new HashMap<String, Object>();
        m.put("media", data.getMedia(mediaId));
        return super.showForm(arg0, arg1, arg2, m);
    }

}
