/*******************************************************************************
* channel.h: Channel Encapsulation
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: channel.h,v 1.1 2001/10/06 21:23:37 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _CHANNEL_H_
#define _CHANNEL_H_


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
class C_Channel
{
 public:
  C_Channel(const C_String& strName);
  virtual ~C_Channel();
  
  // The corresponding output must be initialised before use and destroyed
  // after use
  C_Output* GetOutput();
  void ReleaseOutput();

  // channel info
  C_String GetName() const
  { return m_strName; }
  unsigned int GetBuffCapacity() const
  { return m_pOutput->GetBuffCapacity(); }

  // En attendant les channels streamables
  //virtual C_String GetConfig() = 0;
  //virtual void SetConfig(const C_String& strCfg) = 0;

  // Is channel already used ?
  bool IsFree() const
  { return m_bIsFree; }

 protected:
  C_String m_strName;
  C_Output* m_pOutput;
  bool m_bIsFree;
};



//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
class C_NetChannel : public C_Channel
{
 public:
  C_NetChannel(const C_String& strName);

  // En attendant les channels streamables
  //virtual C_String GetConfig();
  //virtual void SetConfig(const C_String& strCfg);

 private:
  C_String m_strConfig;
};



#else
#error "Multiple inclusions of channel.h"
#endif

