/*******************************************************************************
* reader.cpp: Stream readers
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: reader.cpp,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"

#include "../../server/broadcast.h"

#include "reader.h"


/*******************************************************************************
* C_MpegReader
********************************************************************************
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Construuctor
//------------------------------------------------------------------------------
C_MpegReader::C_MpegReader(C_Broadcast* pBroadcast)
{
  ASSERT(pBroadcast);

  m_pBroadcast = pBroadcast;

  m_bDiscontinuity = false;
}


//------------------------------------------------------------------------------
// Destructor
//------------------------------------------------------------------------------
C_MpegReader::~C_MpegReader()
{
}


/*******************************************************************************
* C_MpegFileReader
********************************************************************************
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
C_MpegFileReader::C_MpegFileReader(C_Broadcast* pBroadcast) :
                        C_MpegReader(pBroadcast),
                        m_cFile(pBroadcast->GetOption("filename"))
{
  if(pBroadcast->GetOption("loop") == "1")
    m_bLoop = true;
  else
    m_bLoop = false;
}


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------
void C_MpegFileReader::Init()
{
  m_cFile.Open("r");
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_MpegFileReader::Read(byte* pBuff, int iSize)
{
  try 
  {
    int iRc = m_cFile.Read(pBuff, iSize);
    // Loop on stream and set the discontinuity flag
    if((iRc == FILE_EOF) && m_bLoop)
    {
      m_cFile.Seek(0, FILE_SEEK_BEGIN);
      m_bDiscontinuity = true;
      iRc = m_cFile.Read(pBuff, iSize);
    }
    return iRc;
  }
  catch(E_File e)
  {
    return MPEG_STREAMERROR;
  }
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_MpegFileReader::Seek(s64 iOffset, int bStartPos)
{
  return m_cFile.Seek(iOffset, bStartPos);
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
s64 C_MpegFileReader::Size()
{
  ASSERT(false);
  return 0;
}


