/*******************************************************************************
* netchannel.cpp: network channel
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: netchannel.cpp,v 1.3 2001/11/29 16:11:42 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"
#include "../../mpeg/mpeg.h"
#include "../../mpeg/ts.h"
#include "../../server/buffer.h"
#include "../../server/output.h"
#include "../../server/channel.h"

#include "netoutput.h"
#include "netchannel.h"


//------------------------------------------------------------------------------
// Library declaration
//------------------------------------------------------------------------------
#ifdef __PLUGIN__
GENERATE_LIB_ARGS(C_NetChannelModule, handle);
#endif


//------------------------------------------------------------------------------
// Builtin declaration
//------------------------------------------------------------------------------
#ifdef __BUILTIN__
C_Module* NewBuiltin_netchannel(handle hLog)
{
  return new C_NetChannelModule(hLog);
}
#endif


//******************************************************************************
// class C_NetChannel
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_NetChannel::C_NetChannel(C_Module* pModule,
                           const C_String& strName) : C_Channel(pModule,
                                                                strName)
{
  C_Application* pApp = C_Application::GetApp();
  ASSERT(pApp);

  C_String strInterface = pApp->GetSetting(m_strName+".Interface", "");
  C_String strSrcHost = pApp->GetSetting(m_strName+".SrcHost", "0.0.0.0");
  C_String strSrcPort = pApp->GetSetting(m_strName+".SrcPort", "1234");
  C_String strDstHost = pApp->GetSetting(m_strName+".DstHost", "239.0.0.3");
  C_String strDstPort = pApp->GetSetting(m_strName+".DstPort", "1234");

  m_pOutput = new C_NetOutput(strInterface,
                              strSrcHost, strSrcPort, strDstHost, strDstPort);
}


